/*
reverse_bfs
by jacint
Performs a bfs on the out edges. It does not count predecessors, 
only the distances, but one can easily modify it to know the pred as well.

Constructor: 

reverse_bfs(graph_type& G, node_iterator t)



Member functions:

void run(): runs a reverse bfs from t

  The following function should be used after run() was already run.

int dist(node_iterator v) : returns the distance from v to t. It is the number of nodes if t is not reachable from v.

*/
#ifndef REVERSE_BFS_HH
#define REVERSE_BFS_HH

#include <queue>

#include <marci_graph_traits.hh>
#include <marci_property_vector.hh>



namespace  marci {

  template <typename graph_type>
  class reverse_bfs {
    typedef typename graph_traits<graph_type>::node_iterator node_iterator;
    //typedef typename graph_traits<graph_type>::edge_iterator edge_iterator;
    typedef typename graph_traits<graph_type>::each_node_iterator each_node_iterator;
    typedef typename graph_traits<graph_type>::in_edge_iterator in_edge_iterator;


    graph_type& G;
    node_iterator t;
//    node_property_vector<graph_type, edge_iterator> pred;
    node_property_vector<graph_type, int> distance;
    

  public :

    /*
      The distance of the nodes is n, except t for which it is 0.
    */
    reverse_bfs(graph_type& _G, node_iterator _t) : G(_G), t(_t), distance(G, number_of(G.first_node())) {
      distance.put(t,0);
    }
    
    void run() {

      node_property_vector<graph_type, bool> reached(G, false); 
      reached.put(t, true);

      std::queue<node_iterator> bfs_queue;
      bfs_queue.push(t);

      while (!bfs_queue.empty()) {

        node_iterator v=bfs_queue.front();	
	bfs_queue.pop();

	for(in_edge_iterator e=G.first_in_edge(v); e.valid(); ++e) {
	  node_iterator w=G.tail(e);
	  if (!reached.get(w)) {
	    bfs_queue.push(w);
	    distance.put(w, distance.get(v)+1);
	    reached.put(w, true);
	  }
	}
      }
    }



    int dist(node_iterator v) {
      return distance.get(v);
    }


  };

} // namespace marci

#endif //REVERSE_BFS_HH


