// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>

#include <list_graph.h>
//#include <smart_graph.h>
//#include <dimacs.h>
#include <time_measure.h>
#include <for_each_macros.h>
#include <bfs_iterator.h>
#include <graph_wrapper.h>
#include <maps.h>
#include <edmonds_karp.h>

using namespace hugo;

int main() {
  typedef UndirListGraph Graph; 
  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;

  Graph g;
  //Node s, t;
  //Graph::EdgeMap<int> cap(g);
  //readDimacsMaxFlow(std::cin, g, s, t, cap);
  std::vector<Graph::Node> s_nodes;
  std::vector<Graph::Node> t_nodes;
  for (int i=0; i<3; ++i) s_nodes.push_back(g.addNode());
  for (int i=0; i<3; ++i) t_nodes.push_back(g.addNode());
  g.addEdge(s_nodes[0], t_nodes[2]);
  g.addEdge(t_nodes[1], s_nodes[2]);
  
  Graph::NodeMap<int> ref_map(g, -1);
  IterableBoolMap< Graph::NodeMap<int> > bipartite_map(ref_map);
  for (int i=0; i<3; ++i) bipartite_map.insert(s_nodes[i], false);
  for (int i=0; i<3; ++i) bipartite_map.insert(t_nodes[i], true);
  typedef BipartiteGraphWrapper<Graph> BGW;
  BGW bgw(g, bipartite_map);
  FOR_EACH_LOC(BGW::EdgeIt, e, bgw) {
    std::cout << bgw.tail(e) << "->" << bgw.head(e) << std::endl;
  }

  BGW::NodeMap<int> dbyj(bgw);
  BGW::EdgeMap<int> dbyxcj(bgw);

  typedef stGraphWrapper<BGW> stGW;
  stGW stgw(bgw);
  ConstMap<stGW::Edge, int> const1map(1);
  stGW::NodeMap<int> ize(stgw);
  stGW::EdgeMap<int> flow(stgw);

  BfsIterator< BGW, BGW::NodeMap<bool> > bfs(bgw);
  Graph::NodeIt si;
  Graph::Node s; 
  s=g.first(si);
  bfs.pushAndSetReached(BGW::Node(s));
  while (!bfs.finished()) ++bfs;

  BGW::EdgeMap<bool> cap(bgw);
  BGW::EdgeMap<bool> flow1(bgw);

  typedef ResGraphWrapper< BGW, int, BGW::EdgeMap<bool>, BGW::EdgeMap<bool> > 
    RBGW;
  RBGW rbgw(bgw, cap, flow1);
  RBGW::NodeMap<int> u(rbgw);
  

  MaxFlow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
    max_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, flow);
  max_flow_test.augmentOnShortestPath();
  max_flow_test.augmentOnShortestPath();

  std::cout << max_flow_test.flowValue() << std::endl;

  return 0;
}
