// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>
#include <cstdlib>

#include <LEDA/graph.h>
#include <LEDA/mcb_matching.h>
#include <LEDA/list.h>
#include <LEDA/graph_gen.h>

#include <leda_graph_wrapper.h>
#include <list_graph.h>
//#include <smart_graph.h>
//#include <dimacs.h>
#include <time_measure.h>
#include <for_each_macros.h>
//#include <bfs_iterator.h>
#include <graph_wrapper.h>
#include <maps.h>
#include <edmonds_karp.h>
#include <preflow.h>

/**
 * Inicializalja a veletlenszamgeneratort.
 * Figyelem, ez nem jo igazi random szamokhoz,
 * erre ne bizzad a titkaidat!
 */
void random_init()
{
	unsigned int seed = getpid();
	seed |= seed << 15;
	seed ^= time(0);

	srand(seed);
}

/**
 * Egy veletlen int-et ad vissza 0 es m-1 kozott.
 */
int random(int m)
{
  return int( double(m) * rand() / (RAND_MAX + 1.0) );
}

using namespace hugo;

int main() {
  //for leda graph
  leda::graph lg;
  //lg.make_undirected();
  typedef LedaGraphWrapper<leda::graph> Graph;
  Graph g(lg);

  //for UndirListGraph
  //typedef UndirListGraph Graph; 
  //Graph g;

  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;

  std::vector<Graph::Node> s_nodes;
  std::vector<Graph::Node> t_nodes;

  int a;
  std::cout << "number of nodes in the first color class=";
  std::cin >> a; 
  int b;
  std::cout << "number of nodes in the second color class=";
  std::cin >> b; 
  int m;
  std::cout << "number of edges=";
  std::cin >> m; 
  int k;
  std::cout << "A bipartite graph is a random group graph if the color classes \nA and B are partitiones to A_0, A_1, ..., A_{k-1} and B_0, B_1, ..., B_{k-1} \nas equally as possible \nand the edges from A_i goes to A_{i-1 mod k} and A_{i+1 mod k}.\n";
  std::cout << "number of groups in LEDA random group graph=";
  std::cin >> k; 

  leda_list<leda_node> lS;
  leda_list<leda_node> lT;
  random_bigraph(lg, a, b, m, lS, lT, k);

//   for (int i=0; i<a; ++i) s_nodes.push_back(g.addNode());
//   for (int i=0; i<b; ++i) t_nodes.push_back(g.addNode());

//   random_init();
//   for(int i=0; i<m; ++i) {
//     g.addEdge(s_nodes[random(a)], t_nodes[random(b)]);
//   }

  Graph::NodeMap<int> ref_map(g, -1);

  IterableBoolMap< Graph::NodeMap<int> > bipartite_map(ref_map);
//   for (int i=0; i<a; ++i) bipartite_map.insert(s_nodes[i], false);
//   for (int i=0; i<b; ++i) bipartite_map.insert(t_nodes[i], true);
  leda_node ln;
  forall(ln, lS) bipartite_map.insert(ln, false);
  forall(ln, lT) bipartite_map.insert(ln, true);

  typedef BipartiteGraphWrapper<Graph> BGW;
  BGW bgw(g, bipartite_map);

  //  BGW::NodeMap<int> dbyj(bgw);
  //  BGW::EdgeMap<int> dbyxcj(bgw);

  typedef stGraphWrapper<BGW> stGW;
  stGW stgw(bgw);
  ConstMap<stGW::Edge, int> const1map(1);
  stGW::EdgeMap<int> flow(stgw);

  Timer ts;
  FOR_EACH_LOC(stGW::EdgeIt, e, stgw) flow.set(e, 0);
  ts.reset();
  //  stGW::EdgeMap<int> pre_flow(stgw);
  Preflow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
    pre_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, flow/*, true*/);
  pre_flow_test.run();
  std::cout << "HUGO pre flow value: " << pre_flow_test.flowValue() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
//   FOR_EACH_LOC(stGW::EdgeIt, e, stgw) { 
//     std::cout << e << ": " << pre_flow[e] << "\n"; 
//   }
  std::cout << "\n";

  ts.reset();  
  leda_list<leda_edge> ml=MAX_CARD_BIPARTITE_MATCHING(lg);
  //  stGW::EdgeMap<int> pre_flow(stgw);
  //Preflow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
  //  pre_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, pre_flow, true);
  //pre_flow_test.run();
  std::cout << "LEDA matching value: " << ml.size() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
//   FOR_EACH_LOC(stGW::EdgeIt, e, stgw) { 
//     std::cout << e << ": " << pre_flow[e] << "\n"; 
//   }
  std::cout << "\n";

  FOR_EACH_LOC(stGW::EdgeIt, e, stgw) flow.set(e, 0);
  ts.reset();
  MaxFlow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
    max_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, flow);
//  while (max_flow_test.augmentOnShortestPath()) { }
  typedef ListGraph MutableGraph;
//  while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) {
  while (max_flow_test.augmentOnBlockingFlow2()) {
   std::cout << max_flow_test.flowValue() << std::endl;
  }
  std::cout << "HUGO blocking flow value: " << max_flow_test.flowValue() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
//   FOR_EACH_LOC(stGW::EdgeIt, e, stgw) { 
//     std::cout << e << ": " << max_flow[e] << "\n"; 
//   }
//   std::cout << "\n";

  return 0;
}
