#include <xy.h>
#include <iostream>
using namespace std;
using namespace hugo;

bool passed = true;

void check(bool rc, char *msg="") {
  passed = passed && rc;
  if(!rc) {
    std::cerr << "Test failed! ("<< msg << ")" << std::endl; \
 

  }
}



int main()
{

  cout << "Testing classes xy and boundingbox." << endl;

	typedef xy<int> XY;
	
	XY seged;
	XY a(1,2);
	XY b(3,4);

	seged = a+b;
	check(seged.x==4 && seged.y==6);

	seged = a-b;
	check(seged.x==-2 && seged.y==-2, "a-b");

	check(a.normSquare()==5);
	check(a*b==11, "a*b");

	int l=2;
	seged = a*l;
	check(seged.x==2 && seged.y==4, "a*l");

	seged = b/l;
	check(seged.x==1 && seged.y==2, "b/l");

	typedef BoundingBox<int> BB;
	BB doboz1;
	check(doboz1.empty(), "empty? Should be.");
	
	doboz1 += a;
	check(!doboz1.empty(), "empty? Should not be.");
	doboz1 += b;

	check(doboz1.bottomLeft().x==1 && 
	      doboz1.bottomLeft().y==2 &&
	      doboz1.topRight().x==3 && 
	      doboz1.topRight().y==4,  
	      "added points to box");

	seged.x=2;seged.y=3;
	check(doboz1.inside(seged),"Inside? Should be.");

	seged.x=1;seged.y=3;
	check(doboz1.inside(seged),"Inside? Should be.");

	seged.x=0;seged.y=3;
	check(!doboz1.inside(seged),"Inside? Should not be.");

	BB doboz2(seged);
	check(!doboz2.empty(), "empty? Should not be. Constructed from 1 point.");

	doboz2 += doboz1;
	check(doboz2.inside(seged),"Inside? Should be. Incremented a box with an other.");

	cout << (passed ? "All tests passed." : "Some of the tests failed!!!")
	     << endl;

	return passed ? 0 : 1;

}
