#include"lp_solver_skeleton.h"
#include"lp_glpk.h"
#include<lemon/list_graph.h>

using namespace lemon;

void lpTest(LpSolverBase & lp)
{
  typedef LpSolverBase LP;

  std::vector<LP::Col> x;
  for(int i=0;i<10;i++) x.push_back(lp.addCol());

  std::vector<LP::Col> y(10);
  lp.addColSet(y);

  std::map<int,LP::Col> z;
  
  z.insert(std::make_pair(12,INVALID));
  z.insert(std::make_pair(2,INVALID));
  z.insert(std::make_pair(7,INVALID));
  z.insert(std::make_pair(5,INVALID));
  
  lp.addColSet(z);


  LP::Expr e;
  e[x[3]]=2;
  e[x[3]]=4;
  e[x[3]]=1;
  e.constComp()=12;

  LP::Col p1,p2,p3,p4,p5;
  
  lp.addRow(LP::INF,e,23);
  lp.addRow(LP::INF,3.0*(p1+p2)-p3,23);
  lp.addRow(LP::INF,3.0*(x[1]+x[2]/2)-x[3],23);
  lp.addRow(LP::INF,3.0*(p1+p2*2-5*p3+12-p4/3)+2*p4-4,23);
  lp.addRow(LP::INF,3.0*(x[1]+x[2]*2-5*x[3]+12-x[4]/3)+2*x[4]-4,23);

  lp.addRow(x[1]+x[3]<=x[5]-3);
  lp.addRow(-7<=x[1]+x[3]-12<=3);
}


template<class G,class C>
double maxFlow(const G &g,const C &cap,typename G::Node s,typename G::Node t)
{
  LpGlpk lp;
  
  typedef G Graph;
  typedef typename G::Node Node;
  typedef typename G::NodeIt NodeIt;
  typedef typename G::Edge Edge;
  typedef typename G::EdgeIt EdgeIt;
  typedef typename G::OutEdgeIt OutEdgeIt;
  typedef typename G::InEdgeIt InEdgeIt;
  
  typename G::EdgeMap<LpGlpk::Col> x(g);
  // lp.addColSet(x);
  for(EdgeIt e(g);e!=INVALID;++e) x[e]=lp.addCol();
  
  for(EdgeIt e(g);e!=INVALID;++e) {
    lp.setColUpperBound(x[e],cap[e]);
    lp.setColLowerBound(x[e],0);
  }

  for(NodeIt n(g);n!=INVALID;++n) if(n!=s&&n!=t) {
    LpGlpk::Expr ex;
    for(InEdgeIt  e(g,n);e!=INVALID;++e) ex+=x[e];
    for(OutEdgeIt e(g,n);e!=INVALID;++e) ex-=x[e];
    lp.addRow(0,ex,0);
  }
  {
    LpGlpk::Expr ex;
    for(InEdgeIt  e(g,t);e!=INVALID;++e) ex+=x[e];
    for(OutEdgeIt e(g,t);e!=INVALID;++e) ex-=x[e];
    lp.setObj(ex);
  }

  lp.solve();

  return 0;
}

int main() 
{
  LpSolverSkeleton lp_skel;
  LpGlpk lp_glpk;

  lpTest(lp_skel);
  lpTest(lp_glpk);

  ListGraph g;
  ListGraph::EdgeMap<double> cap(g);
  
  maxFlow(g,cap,ListGraph::NodeIt(g),ListGraph::NodeIt(g));

}
