// -*- c++ -*-
#ifndef DIMACS_H
#define DIMACS_H

#include <iostream>
#include <string>
#include <vector>

namespace hugo {

  template<typename Graph, typename CapacityMap>
  void readDimacsMaxFlow(std::istream& is, Graph &G, typename Graph::Node &s, typename Graph::Node &t, CapacityMap& capacity) {
    G.clear();
    int cap;
    char d;
    std::string problem;
    char c;
    int i, j;
    std::string str;
    int n, m; 
    typename Graph::Edge e;
    std::vector<typename Graph::Node> nodes;
    while (is>>c) {
      switch (c) {
      case 'c': //comment
	getline(is, str);
	break;
      case 'p': //problem definition
	is >> problem >> n >> m;
	getline(is, str);
	nodes.resize(n+1);
	for (int k=1; k<=n; ++k) nodes[k]=G.addNode();
	break;
      case 'n': //node definition
	if (problem=="sp") { //shortest path problem
	  is >> i;
	  getline(is, str);
	  s=nodes[i];
	}
	if (problem=="max") { //max flow problem
	  is >> i >> d;
	  getline(is, str);
	  if (d=='s') s=nodes[i];
	  if (d=='t') t=nodes[i];
	}
	break;
      case 'a':
	is >> i >> j >> cap;
	getline(is, str);
	e=G.addEdge(nodes[i], nodes[j]);
	capacity.update();
	capacity.set(e, cap);
	break;
      }
    }
  }
  
} //namespace hugo

#endif //DIMACS_H
