#include <iostream>
#include <boost/utility.hpp>

using namespace std;
using namespace boost;

struct True {
  static const bool value = true;
};
struct False {
  static const bool value = false;
};

// Here are some graph structures. Some of them define the type "OneTag"
// to True or False, some does not. Not defining a tag is (or at least
// should be) equivalent to defining it to "False".
struct Graph1 {};
struct Graph2 {
  typedef True OneTag;
};
struct Graph3 {
  typedef False OneTag;
};


/**************** The first method to use tags ****************/

template <typename Graph, typename Enable = void>
struct HasOneTag {
  typedef False TheTag;
};

// specialization for those graphs which defined the tag to be true:
template <typename Graph>
struct HasOneTag<Graph, typename enable_if<typename Graph::OneTag>::type > {
  typedef True TheTag;
};

template <typename Graph>
int cn1(const Graph &, False) {
  return 0;
}

template <typename Graph>
int cn1(const Graph &, True) {
  return 1;
}

template <typename Graph>
int cn1(const Graph &g) {
  return cn1(g, typename HasOneTag<Graph>::TheTag());
}

/**************** The second method ****************/

// An artificial type to provoke a conversion to avoid ambuguity...
template <typename T>
struct Wrap {
  const T &value;
  Wrap(const T &t) : value(t) {}
};

template <typename Graph>
typename enable_if<typename Graph::OneTag, int>::type
_cn2(const Graph &) {
  return 1;
}

template <typename Graph>
int _cn2(Wrap<Graph>) {
  return 0;
}

template <typename Graph>
int cn2(const Graph& g) {
  return _cn2<Graph>(g);
}


int main() {
  Graph1 g1;
  Graph2 g2;
  Graph3 g3;

  cout << "The first method:\n";
  cout << "G1: " << cn1(g1) << endl;
  cout << "G2: " << cn1(g2) << endl;
  cout << "G3: " << cn1(g3) << endl;

  cout << "The second method:\n";
  cout << "G1: " << cn2(g1) << endl;
  cout << "G2: " << cn2(g2) << endl;
  cout << "G3: " << cn2(g3) << endl;

}
