/* -*- C++ -*-
 * src/test/dfs_test.cc - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include "test_tools.h"
#include <lemon/smart_graph.h>
#include <lemon/dfs.h>
#include <lemon/concept/graph.h>

using namespace lemon;

const int PET_SIZE =5;


void check_Dfs_SmartGraph_Compile() 
{
  typedef concept::StaticGraph Graph;

  typedef Graph::Edge Edge;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::NodeIt NodeIt;
 
  typedef Dfs<Graph> DType;
  
  Graph G;
  Node n;
  Edge e;
  int l;
  bool b;
  DType::DistMap d(G);
  DType::PredMap p(G);
  //  DType::PredNodeMap pn(G);
  
  DType dfs_test(G);
  
  dfs_test.run(n);
  
  l  = dfs_test.dist(n);
  e  = dfs_test.pred(n);
  n  = dfs_test.predNode(n);
  d  = dfs_test.distMap();
  p  = dfs_test.predMap();
  //  pn = dfs_test.predNodeMap();
  b  = dfs_test.reached(n);

}


void check_Dfs_Function_Compile() 
{
  typedef int VType;
  typedef concept::StaticGraph Graph;

  typedef Graph::Edge Edge;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::NodeIt NodeIt;
  typedef concept::ReadMap<Edge,VType> LengthMap;
   
  dfs(Graph(),Node()).run();
  dfs(Graph()).source(Node()).run();
  dfs(Graph())
    .predMap(concept::WriteMap<Node,Edge>())
    .distMap(concept::WriteMap<Node,VType>())
    .reachedMap(concept::ReadWriteMap<Node,bool>())
    .processedMap(concept::WriteMap<Node,bool>())
    .run(Node());
  
}

int main()
{
    
  typedef SmartGraph Graph;

  typedef Graph::Edge Edge;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::EdgeMap<int> LengthMap;

  Graph G;
  Node s, t;
  PetStruct<Graph> ps = addPetersen(G,PET_SIZE);
   
  s=ps.outer[2];
  t=ps.inner[0];
  
  Dfs<Graph> dfs_test(G);
  dfs_test.run(s);  
  
  for(NodeIt v(G); v!=INVALID; ++v) {
    check(dfs_test.reached(v),"Each node should be reached.");
    if ( dfs_test.pred(v)!=INVALID ) {
      Edge e=dfs_test.pred(v);
      Node u=G.source(e);
      check(u==dfs_test.predNode(v),"Wrong tree.");
      check(dfs_test.dist(v) - dfs_test.dist(u) == 1,
	    "Wrong distance. (" << dfs_test.dist(u) << "->" 
	    <<dfs_test.dist(v) << ')');
    }
  }
}

