// -*- C++ -*- //

#ifndef HUGO_ERROR_H
#define HUGO_ERROR_H

//! \ingroup misc
//! \file
//! \brief Basic error handling (signaling) routines.

#include <exception>
#include <string>
#include <sstream>


namespace hugo {

  /**
   * \brief Generic exception class.
   *
   * \todo Do we need this?
   *
   * \todo Don't we need different kind of exceptions for different kind
   * of errors?
   * Shouldn't we use \<stdexcept\> instead?
   */
  class Exception : public std::exception {
  protected:
    std::ostringstream buf;
  public:
    Exception() {}
    explicit Exception(const std::string &s) { buf << s; }
    Exception(const Exception &e) : std::exception() {
      buf << e.buf.str();
    }
    virtual ~Exception() throw() {}
    
    virtual const char* what() const throw() {
      return buf.str().c_str();
    }

    Exception& operator<<(std::string const& s) { buf << s; return *this; }
    Exception& operator<<(char const *s) { buf << s; return *this; }
    Exception& operator<<(int i) { buf << i; return *this; }
  };

  /**
   * \brief Generic error signaling function.
   *
   * \todo Do we really need this? Is it helpful?
   */
  inline void fault(const std::string &msg) {
    throw Exception(msg);
  }

  /**
   * \brief Macro for mark not yet implemented features.
   *
   * \todo Is this the right place for this? It should be used only in
   * modules under development.
   */

# define FIXME(msg) \
    do { throw ::hugo::Exception() << "FIXME: " msg " (in: "    \
      __FILE__ ", " << __LINE__ << ")";                         \
    } while(false)

}
#endif // HUGO_ERROR_H
