/* -*- mode: C++; indent-tabs-mode: nil; -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library.
 *
 * Copyright (C) 2003-2011
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <benchmark_tools.h>
#include <lemon/circulation.h>
#include <lemon/smart_graph.h>
#include <lemon/lgf_reader.h>
#include <lemon/dimacs.h>
#include <lemon/error.h>
#include <istream>

std::string test_name = "circulation";

using namespace lemon;

int testMain(std::istream &input)
{
  typedef int Value;
  
  SmartDigraph g;
  
  SmartDigraph::ArcMap<Value> lo_cap(g);
  SmartDigraph::ArcMap<Value> up_cap(g);
  SmartDigraph::ArcMap<Value> cost(g);
  SmartDigraph::NodeMap<Value> sup(g);
  
  Timer ti;
  try {
    readDimacsMin(input, g, lo_cap, up_cap, cost, sup);
  } catch (FormatError& error) {
    std::cerr << error.what() << std::endl;
    return 1;
  }
  logTime("fread",ti);

  Timer tf;
  ti.restart();
  Circulation<SmartDigraph,
    SmartDigraph::ArcMap<Value>,SmartDigraph::ArcMap<Value>,
    SmartDigraph::NodeMap<Value> > circ(g,lo_cap,up_cap,sup);
  logTime("setup",ti);
  ti.restart();
  bool res = circ.run();
  logTime("alg",ti);
  logTime("full",tf);
  if(res)
    {
      std::cerr << "A feasible circulation is found\n";
      std::cerr << "Checking...\n";
      ti.restart();
      bool res2 = circ.checkFlow();
      logTime("check",ti);
      if(res2)
        std::cerr << "Success!\n";
      else
        std::cerr << "Oops!!!!\n";
    }
  else
    {
      std::cerr << "A dual solution is found\n";
      std::cerr << "Checking...\n";
      ti.restart();
      bool res2 = circ.checkBarrier();
      logTime("check",ti);
      if(res2)
        std::cerr << "Success!\n";
      else
        std::cerr << "Dual-Oops!!!!\n";

    }
}

