/* -*- mode: C++; indent-tabs-mode: nil; -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library.
 *
 * Copyright (C) 2003-2011
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <benchmark_tools.h>
#include <istream>
#include <lemon/error.h>

using namespace lemon;

std::string instance_name;

int testMain(std::istream &input);

int main(int argc, char **argv)
{
  if(argc!=2) exit(1);

  std::ifstream input;
  input.open((DATADIR_PATH+"/"+argv[1]).c_str());
  
  instance_name = argv[1];

  Timer ti;
  testMain(input);
  logTime("total",ti);
}
