/* -*- C++ -*-
 * src/test/min_cost_flow_test.cc - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <iostream>
#include "test_tools.h"
#include <lemon/list_graph.h>
#include <lemon/min_cost_flow.h>
//#include <path.h>
//#include <maps.h>

using namespace lemon;


bool passed = true;
/*
void check(bool rc, char *msg="") {
  passed = passed && rc;
  if(!rc) {
    std::cerr << "Test failed! ("<< msg << ")" << std::endl; \
 

  }
}
*/


int main()
{
  typedef ListGraph Graph;
  typedef Graph::Node Node;
  typedef Graph::Edge Edge;

  Graph graph;

  //Ahuja knyv pldja

  Node s=graph.addNode();
  Node v1=graph.addNode();  
  Node v2=graph.addNode();
  Node v3=graph.addNode();
  Node v4=graph.addNode();
  Node v5=graph.addNode();
  Node t=graph.addNode();

  Edge s_v1=graph.addEdge(s, v1);
  Edge v1_v2=graph.addEdge(v1, v2);
  Edge s_v3=graph.addEdge(s, v3);
  Edge v2_v4=graph.addEdge(v2, v4);
  Edge v2_v5=graph.addEdge(v2, v5);
  Edge v3_v5=graph.addEdge(v3, v5);
  Edge v4_t=graph.addEdge(v4, t);
  Edge v5_t=graph.addEdge(v5, t);
  

  Graph::EdgeMap<int> length(graph);

  length.set(s_v1, 6);
  length.set(v1_v2, 4);
  length.set(s_v3, 10);
  length.set(v2_v4, 5);
  length.set(v2_v5, 1);
  length.set(v3_v5, 4);
  length.set(v4_t, 8);
  length.set(v5_t, 8);

  Graph::EdgeMap<int> capacity(graph);

  capacity.set(s_v1, 2);
  capacity.set(v1_v2, 2);
  capacity.set(s_v3, 1);
  capacity.set(v2_v4, 1);
  capacity.set(v2_v5, 1);
  capacity.set(v3_v5, 1);
  capacity.set(v4_t, 1);
  capacity.set(v5_t, 2);

  //  ConstMap<Edge, int> const1map(1);
  std::cout << "Mincostflows algorithm test..." << std::endl;

  MinCostFlow< Graph, Graph::EdgeMap<int>, Graph::EdgeMap<int> >
    surb_test(graph, length, capacity, s, t);

  int k=1;

  surb_test.augment();
  check(  surb_test.flowValue() == 1 && surb_test.totalLength() == 19,"One path, total length should be 19");

  check(  surb_test.run(k) == 1 && surb_test.totalLength() == 19,"One path, total length should be 19");

  check(surb_test.checkComplementarySlackness(), "Is the primal-dual solution pair really optimal?");
  
  k=2;
  
  check(  surb_test.run(k) == 2 && surb_test.totalLength() == 41,"Two paths, total length should be 41");

  check(surb_test.checkComplementarySlackness(), "Is the primal-dual solution pair really optimal?");
  
  surb_test.augment();
  surb_test.augment();
  surb_test.augment();
  k=4;

  check(  surb_test.run(k) == 3 && surb_test.totalLength() == 64,"Three paths, total length should be 64");

  check(surb_test.checkComplementarySlackness(), "Is the primal-dual solution pair really optimal?");


  std::cout << (passed ? "All tests passed." : "Some of the tests failed!!!")
	    << std::endl;

  return passed ? 0 : 1;

}
