/* -*- C++ -*-
 * src/test/suurballe_test.cc - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <iostream>
#include <lemon/list_graph.h>
#include <lemon/suurballe.h>
//#include <path.h>
#include "test_tools.h"

using namespace lemon;


bool passed = true;


int main()
{
  typedef ListGraph Graph;
  typedef Graph::Node Node;
  typedef Graph::Edge Edge;

  Graph graph;

  //Ahuja knyv pldja

  Node s=graph.addNode();
  Node v1=graph.addNode();  
  Node v2=graph.addNode();
  Node v3=graph.addNode();
  Node v4=graph.addNode();
  Node v5=graph.addNode();
  Node t=graph.addNode();

  Edge s_v1=graph.addEdge(s, v1);
  Edge v1_v2=graph.addEdge(v1, v2);
  Edge s_v3=graph.addEdge(s, v3);
  Edge v2_v4=graph.addEdge(v2, v4);
  Edge v2_v5=graph.addEdge(v2, v5);
  Edge v3_v5=graph.addEdge(v3, v5);
  Edge v4_t=graph.addEdge(v4, t);
  Edge v5_t=graph.addEdge(v5, t);
  

  Graph::EdgeMap<int> length(graph);

  length.set(s_v1, 6);
  length.set(v1_v2, 4);
  length.set(s_v3, 10);
  length.set(v2_v4, 5);
  length.set(v2_v5, 1);
  length.set(v3_v5, 5);
  length.set(v4_t, 8);
  length.set(v5_t, 8);

  std::cout << "Minlengthpaths algorithm test..." << std::endl;

  
  int k=3;
  Suurballe< Graph, Graph::EdgeMap<int> >
    surb_test(graph, length, s, t);

  check(  surb_test.run(k) == 2 && surb_test.totalLength() == 46,
	  "Two paths, total length should be 46");

  check(  surb_test.checkComplementarySlackness(),
	  "Complementary slackness conditions are not met.");

  //  typedef DirPath<Graph> DPath;
  //  DPath P(graph);

  /*
  surb_test.getPath(P,0);
  check(P.length() == 4, "First path should contain 4 edges.");  
  std::cout<<P.length()<<std::endl;
  surb_test.getPath(P,1);
  check(P.length() == 3, "Second path: 3 edges.");
  std::cout<<P.length()<<std::endl;
  */  

  k=1;
  check(  surb_test.run(k) == 1 && surb_test.totalLength() == 19,
	  "One path, total length should be 19");

  check(  surb_test.checkComplementarySlackness(),
	  "Complementary slackness conditions are not met.");
 
  //  surb_test.getPath(P,0);
  //  check(P.length() == 4, "First path should contain 4 edges.");  

  std::cout << (passed ? "All tests passed." : "Some of the tests failed!!!")
	    << std::endl;

  return passed ? 0 : 1;

}
