/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "all_include.h"
#include "main_win.h"
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

#include "gettext.h"

#define MAIN_PART

std::vector <std::string> arc_property_strings;
std::vector <double> arc_property_defaults;
std::vector <std::string> node_property_strings;
std::vector <double> node_property_defaults;
int longest_property_string_length;

int main(int argc, char *argv[])
{
  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(PACKAGE, "UTF-8");
  textdomain(PACKAGE);

  //initializing

  arc_property_strings.resize(EDGE_PROPERTY_NUM);
  arc_property_strings[E_WIDTH]="Arc Width";
  arc_property_strings[E_COLOR]="Arc Color";
  arc_property_strings[E_TEXT]="Arc Text";

  arc_property_defaults.resize(EDGE_PROPERTY_NUM);
  arc_property_defaults[E_WIDTH]=10.0;
  arc_property_defaults[E_COLOR]=100;
  arc_property_defaults[E_TEXT]=0;

  node_property_strings.resize(NODE_PROPERTY_NUM);
  node_property_strings[N_RADIUS]="Node Radius";
  node_property_strings[N_COLOR]="Node Color";
  node_property_strings[N_TEXT]="Node Text";

  node_property_defaults.resize(NODE_PROPERTY_NUM);
  node_property_defaults[N_RADIUS]=20.0;
  node_property_defaults[N_COLOR]=100;
  node_property_defaults[N_TEXT]=0;

  longest_property_string_length=0;
  for(int i=0;i<EDGE_PROPERTY_NUM;i++)
    {
      int j=arc_property_strings[i].size();
      if(j>longest_property_string_length)
	{
	  longest_property_string_length=j;
	}
    }
  for(int i=0;i<NODE_PROPERTY_NUM;i++)
    {
      int j=node_property_strings[i].size();
      if(j>longest_property_string_length)
	{
	  longest_property_string_length=j;
	}
    }


  //initializing GUI

  Gnome::Canvas::init();
  Gtk::Main app(argc, argv);

  MainWin mytab;

//   if ((argc == 2) && (Glib::file_test(argv[1], Glib::FILE_TEST_IS_REGULAR)))
//     {
//       mytab.readFile(argv[1]);
//     }
  if(argc>=2)
  {
    for(int i=1;i<argc;i++)
    {
      if(Glib::file_test(argv[i], Glib::FILE_TEST_IS_REGULAR))
      {
        mytab.readFile(argv[i]);
      }
    }
  }
  else
    {
      mytab.newTab();
    }
  
  app.run(mytab);

  return 0;
}
