#include <iostream>

#include <hugo/error.h>

using namespace hugo;
using std::cout;
using std::endl;

void faulty_fn() {
  fault("This is a fault message");
}

void exception_fn() {
  throw Exception("This is a fn throwing excpt with some args: ") 
    << 5 << ", " << 18;
}

void unfinished_fn() {
  FIXME("unfinished_fn() is unfinished!");
}


int main() {
  bool no_errors = false;

  try {
    cout << "Trying a faulty function\n";
    faulty_fn();
    no_errors = true;
    cout << "FAILED!\n";
  }
  catch(const Exception &e) {
    cout << "E: " << e.what() << endl;
  }

  try {
    cout << "Trying a function throwing Exception\n";
    exception_fn();
    no_errors = true;
    cout << "FAILED!\n";
  }
  catch(const Exception &e) {
    cout << "E: " << e.what() << endl;
  }

  try {
    cout << "Trying a function using FIXME\n";
    unfinished_fn();
    no_errors = true;
    cout << "FAILED!\n";
  }
  catch(const Exception &e) {
    cout << "E: " << e.what() << endl;
  }

  return no_errors ? 1 : 0;
}
