// -*- c++ -*-
#ifndef HUGO_MINLENGTHPATHS_H
#define HUGO_MINLENGTHPATHS_H

///\file
///\brief An algorithm for finding k paths of minimal total length.

#include <iostream>
#include <dijkstra.h>
#include <graph_wrapper.h>
#include <maps.h>

namespace hugo {


  ///\brief Implementation of an algorithm for finding k paths between 2 nodes 
  /// of minimal total length 
  ///
  /// The class \ref hugo::MinLengthPaths "MinLengthPaths" implements
  /// an algorithm which finds k edge-disjoint paths
  /// from a given source node to a given target node in an
  /// edge-weighted directed graph having minimal total weigth (length).

  template <typename Graph, typename LengthMap>
  class MinLengthPaths {

    typedef typename LengthMap::ValueType Length;

    typedef typename Graph::Node Node;
    typedef typename Graph::NodeIt NodeIt;
    typedef typename Graph::Edge Edge;
    typedef typename Graph::OutEdgeIt OutEdgeIt;
    typedef typename Graph::EdgeMap<int> EdgeIntMap;

    typedef ConstMap<Edge,int> ConstMap;

    typedef ResGraphWrapper<const Graph,int,EdgeIntMap,ConstMap> ResGraphType;


    class ModLengthMap {   
      typedef typename ResGraphType::NodeMap<Length> NodeMap;
      const ResGraphType& G;
      const EdgeIntMap& rev;
      const LengthMap &ol;
      const NodeMap &pot;
    public :
      typedef typename LengthMap::KeyType KeyType;
      typedef typename LengthMap::ValueType ValueType;

      ValueType operator[](typename ResGraphType::Edge e) const {     
	if ( (1-2*rev[e])*ol[e]-(pot[G.head(e)]-pot[G.tail(e)] ) <0 ){
	  ///\TODO This has to be removed
	  std::cout<<"Negative length!!"<<std::endl;
	}
	return (1-2*rev[e])*ol[e]-(pot[G.head(e)]-pot[G.tail(e)]);   
      }     

      ModLengthMap(const ResGraphType& _G, const EdgeIntMap& _rev, 
		   const LengthMap &o,  const NodeMap &p) : 
	G(_G), rev(_rev), ol(o), pot(p){}; 
    };
    

    const Graph& G;
    const LengthMap& length;

    //auxiliary variable
    //The value is 1 iff the edge is reversed
    EdgeIntMap reversed; 

    
  public :


    MinLengthPaths(Graph& _G, LengthMap& _length) : G(_G), 
      length(_length), reversed(_G)/*, dijkstra_dist(_G)*/{ }

    ///Runs the algorithm
    
    ///Runs the algorithm
    ///Returns k if there are at least k edge-disjoint paths from s to t.
    ///Otherwise it returns the number of edge-disjoint paths from s to t.
    int run(Node s, Node t, int k) {
      ConstMap const1map(1);

      ResGraphType res_graph(G, reversed, const1map);

      //Initialize the copy of the Dijkstra potential to zero
      typename ResGraphType::NodeMap<Length> dijkstra_dist(res_graph);
      ModLengthMap mod_length(res_graph, reversed, length, dijkstra_dist);

      Dijkstra<ResGraphType, ModLengthMap> dijkstra(res_graph, mod_length);
      
      for (int i=0; i<k; ++i){
	dijkstra.run(s);
	if (!dijkstra.reached(t)){
	  //There is no k path from s to t
	  /// \TODO mit keresett itt ez a ++?
	  return i;
	};
	
	{
	  //We have to copy the potential
	  typename ResGraphType::NodeIt n;
	  for ( res_graph.first(n) ; res_graph.valid(n) ; res_graph.next(n) ) {
	      dijkstra_dist[n] += dijkstra.distMap()[n];
	  }
	}


	//Reversing the sortest path
	Node n=t;
	Edge e;
	while (n!=s){
	  e = dijkstra.pred(n);
	  n = dijkstra.predNode(n);
	  reversed[e] = 1-reversed[e];
	}

	  
      }
      return k;
    }





  }; //class MinLengthPaths


} //namespace hugo

#endif //HUGO_MINLENGTHPATHS_H
