// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>
#include <cstdlib>

#include <list_graph.h>
//#include <smart_graph.h>
//#include <dimacs.h>
#include <hugo/time_measure.h>
#include <for_each_macros.h>
#include <bfs_iterator.h>
#include <bipartite_graph_wrapper.h>
#include <hugo/maps.h>
#include <max_flow.h>

using namespace hugo;

// template <typename Graph, typename EdgeCap, typename NodeCap, 
// 	  typename EdgeFlow, typename NodeFlow>
// class MaxMatching : public MaxFlow<stGraphWrapper<Graph>, 
// 				   stGraphWrapper<Graph>:: EdgeMapWrapper<EdgeCan, NodeCap>, stGraphWrapper<Graph>::EdgeMapWrapper<EdgeFlow, NodeFlow> > {
//   typedef MaxFlow<stGraphWrapper<Graph>, 
// 		  stGraphWrapper<Graph>::EdgeMapWrapper<EdgeCan, NodeCap>, 
// 		  stGraphWrapper<Graph>::EdgeMapWrapper<EdgeFlow, NodeFlow> >
//   Parent;
// protected:
//   stGraphWrapper<Graph> gw;
//   stGraphWrapper<Graph>::EdgeMapWrapper<EdgeCap, NodeCap> cap;
//   stGraphWrapper<Graph>::EdgeMapWrapper<EdgeFlow, NodeFlow> flow;
//   //graph* g;
//   //EdgeCap* edge_cap;
//   //EdgeFlow* edge_flow;
// public:
//   MaxMatching(Graph& _g, EdgeCap& _edge_cap, NodeCap& _node_cap, 
// 	      EdgeFlow& _edge_flow, NodeFlow& _node_flow) : 
//     MaxFlow(), gw(_g), 
//     cap(_edge_cap, _node_cap), flow(_edge_flow, _node_flow) {
//     Parent::set(gw, cap, flow);
//   }
// };

template <typename Graph, typename EdgeCap, typename NodeCap, 
	  typename EdgeFlow, typename NodeFlow>
class MaxMatching {
protected:
//   EdgeCap* edge_cap;
//   NodeCap* node_cap;
//   EdgeFlow* edge_flow;
//   NodeFlow* node_flow;
  typedef  stGraphWrapper<Graph> stGW;
  stGW stgw;
  typedef typename stGW::template EdgeMapWrapper<EdgeCap, NodeCap> CapMap; 
  CapMap cap;
  NodeFlow* node_flow;
  typedef typename stGW::template EdgeMapWrapper<EdgeFlow, NodeFlow> FlowMap;
  FlowMap flow;
  MaxFlow<stGW, int, CapMap, FlowMap> mf;
  //graph* g;
  //EdgeCap* edge_cap;
  //EdgeFlow* edge_flow;
public:
  MaxMatching(Graph& _g, EdgeCap& _edge_cap, NodeCap& _node_cap, 
	      EdgeFlow& _edge_flow, NodeFlow& _node_flow) : 
    stgw(_g), 
    cap(_edge_cap, _node_cap), 
    node_flow(0), 
    flow(_edge_flow, _node_flow), 
    mf(stgw, stgw.S_NODE, stgw.T_NODE, cap, flow) { }
  MaxMatching(Graph& _g, EdgeCap& _edge_cap, NodeCap& _node_cap, 
	      EdgeFlow& _edge_flow/*, NodeFlow& _node_flow*/) : 
    stgw(_g), 
    cap(_edge_cap, _node_cap), 
    node_flow(new NodeFlow(_g)), 
    flow(_edge_flow, *node_flow), 
    mf(stgw, stgw.S_NODE, stgw.T_NODE, cap, flow) { }
  ~MaxMatching() { if (node_flow) delete node_flow; }
  void run() { mf.run(); } 
  int matchingValue() { return mf.flowValue(); }
};

/**
 * Inicializalja a veletlenszamgeneratort.
 * Figyelem, ez nem jo igazi random szamokhoz,
 * erre ne bizzad a titkaidat!
 */
void random_init()
{
	unsigned int seed = getpid();
	seed |= seed << 15;
	seed ^= time(0);

	srand(seed);
}

/**
 * Egy veletlen int-et ad vissza 0 es m-1 kozott.
 */
int random(int m)
{
  return int( double(m) * rand() / (RAND_MAX + 1.0) );
}

int main() {
  //typedef UndirListGraph Graph; 
  typedef BipartiteGraph<ListGraph> Graph;
  
  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;

  Graph g;

  std::vector<Graph::Node> s_nodes;
  std::vector<Graph::Node> t_nodes;

  int a;
  std::cout << "number of nodes in the first color class=";
  std::cin >> a; 
  int b;
  std::cout << "number of nodes in the second color class=";
  std::cin >> b; 
  int m;
  std::cout << "number of edges=";
  std::cin >> m; 
  
  std::cout << "Generatig a random bipartite graph..." << std::endl;
  for (int i=0; i<a; ++i) s_nodes.push_back(g.addNode(false));
  for (int i=0; i<b; ++i) t_nodes.push_back(g.addNode(true));

  random_init();
  for(int i=0; i<m; ++i) {
    g.addEdge(s_nodes[random(a)], t_nodes[random(b)]);
  }

//   std::cout << "Edges of the bipartite graph:" << std::endl;
//   FOR_EACH_LOC(EdgeIt, e, g) std::cout << e << " ";
//   std::cout << std::endl;

//   std::cout << "Nodes:" << std::endl;
//   FOR_EACH_LOC(Graph::NodeIt, v, g) std::cout << v << " ";
//   std::cout << std::endl;
//   std::cout << "Nodes in T:" << std::endl;
//   FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::T_CLASS) std::cout << v << " ";
//   std::cout << std::endl;
//   std::cout << "Nodes in S:" << std::endl;
//   FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::S_CLASS) std::cout << v << " ";
//   std::cout << std::endl;

//   std::cout << "Erasing the first node..." << std::endl;
//   NodeIt n;
//   g.first(n);
//   g.erase(n);
//   std::cout << "Nodes of the bipartite graph:" << std::endl;
//   FOR_EACH_GLOB(n, g) std::cout << n << " ";
//   std::cout << std::endl;

//   std::cout << "Nodes in T:" << std::endl;
//   FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::T_CLASS) std::cout << v << " ";
//   std::cout << std::endl;
//   std::cout << "Nodes in S:" << std::endl;
//   FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::S_CLASS) std::cout << v << " ";
//   std::cout << std::endl;

  typedef stGraphWrapper<Graph> stGW;
  stGW stgw(g);
  ConstMap<stGW::Edge, int> const1map(1);

  Timer ts;
  ts.reset();
  stGW::EdgeMap<int> flow(stgw);
  MaxFlow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
    max_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, flow);
  max_flow_test.run();
//  while (max_flow_test.augmentOnShortestPath()) { }
//  typedef ListGraph MutableGraph;
//  while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) {
//  while (max_flow_test.augmentOnBlockingFlow2()) {
//   std::cout << max_flow_test.flowValue() << std::endl;
//  }
  std::cout << "max flow value: " << max_flow_test.flowValue() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
//   FOR_EACH_LOC(stGW::EdgeIt, e, stgw) { 
//     if (flow[e]) std::cout << e << std::endl; 
//   }
  std::cout << std::endl;

  typedef ConstMap<Graph::Edge, int> EdgeCap; 
  EdgeCap ge1(1);
  typedef ConstMap<Graph::Node, int> NodeCap;
  NodeCap gn1(1);
  typedef Graph::EdgeMap<int> EdgeFlow;
  EdgeFlow gef(g); //0
  typedef Graph::NodeMap<int> NodeFlow; 
  NodeFlow gnf(g); //0 

  typedef stGraphWrapper<Graph>::EdgeMapWrapper<EdgeCap, NodeCap> CapMap; 
  typedef stGraphWrapper<Graph>::EdgeMapWrapper<EdgeFlow, NodeFlow> FlowMap; 
  CapMap cm(ge1, gn1);
  FlowMap fm(gef, gnf);

  //Timer ts;
  ts.reset();
  //stGW::EdgeMap<int> flow(stgw);
  MaxFlow<stGW, int, CapMap, FlowMap> 
    max_flow_test1(stgw, stgw.S_NODE, stgw.T_NODE, cm, fm);
  max_flow_test1.run();
//  while (max_flow_test.augmentOnShortestPath()) { }
//  typedef ListGraph MutableGraph;
//  while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) {
//  while (max_flow_test.augmentOnBlockingFlow2()) {
//   std::cout << max_flow_test.flowValue() << std::endl;
//  }
  std::cout << "max flow value: " << max_flow_test1.flowValue() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
//   FOR_EACH_LOC(Graph::EdgeIt, e, g) { 
//     if (gef[e]) std::cout << e << std::endl; 
//   }
  std::cout << std::endl;

  ts.reset();
  FOR_EACH_LOC(Graph::EdgeIt, e, g) gef.set(e, 0); 
  FOR_EACH_LOC(Graph::NodeIt, n, g) gnf.set(n, 0); 
  MaxMatching<Graph, ConstMap<Graph::Edge, int>, ConstMap<Graph::Node, int>, 
    Graph::EdgeMap<int>, Graph::NodeMap<int> > 
    matching_test(g, ge1, gn1, gef, gnf);
  matching_test.run();

  std::cout << "max flow value: " << matching_test.matchingValue() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
//   FOR_EACH_LOC(Graph::EdgeIt, e, g) { 
//     if (gef[e]) std::cout << e << std::endl; 
//   }
  std::cout << std::endl;

  ts.reset();
  FOR_EACH_LOC(Graph::EdgeIt, e, g) gef.set(e, 0); 
  //FOR_EACH_LOC(Graph::NodeIt, n, g) gnf.set(n, 0); 
  MaxMatching<Graph, ConstMap<Graph::Edge, int>, ConstMap<Graph::Node, int>, 
    Graph::EdgeMap<int>, Graph::NodeMap<int> > 
    matching_test_1(g, ge1, gn1, gef/*, gnf*/);
  matching_test_1.run();

  std::cout << "max flow value: " << matching_test_1.matchingValue() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
//   FOR_EACH_LOC(Graph::EdgeIt, e, g) { 
//     if (gef[e]) std::cout << e << std::endl; 
//   }
  std::cout << std::endl;

  return 0;
}
