/* -*- C++ -*-
 * src/lib/lp_base.cc - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

///\file
///\brief The implementation of the LP solver interface.

#include "lp_base.h"
namespace lemon {
  
  const LpSolverBase::Value
  LpSolverBase::INF = std::numeric_limits<Value>::infinity();
  const LpSolverBase::Value
  LpSolverBase::NaN = std::numeric_limits<Value>::quiet_NaN();

  const LpSolverBase::Constr::Value
  LpSolverBase::Constr::INF = std::numeric_limits<Value>::infinity();
  const LpSolverBase::Constr::Value
  LpSolverBase::Constr::NaN = std::numeric_limits<Value>::quiet_NaN();
  
} //namespace lemon
