// -*- mode:C++ -*-
#ifndef HUGO_BENCH_TEST_H
#define HUGO_BENCH_TEST_H

#include<vector>

///An experimental typedef factory
#define GRAPH_TYPEDEF_FACTORY(Graph) \
   typedef typename Graph::   Node      Node;\
   typedef typename Graph::   NodeIt    NodeIn;\
   typedef typename Graph::   Edge      Edge;\
   typedef typename Graph::   EdgeIt    EdgeIt;\
   typedef typename Graph:: InEdgeIt  InEdgeIt;\
   typedef typename Graph::OutEdgeIt OutEdgeIt;

#define GRAPH_TYPEDEF_FACTORY_NOTYPENAME(Graph) \
   typedef Graph::   Node      Node;\
   typedef Graph::   NodeIt    NodeIn;\
   typedef Graph::   Edge      Edge;\
   typedef Graph::   EdgeIt    EdgeIt;\
   typedef Graph:: InEdgeIt  InEdgeIt;\
   typedef Graph::OutEdgeIt OutEdgeIt;
 

///A primitive primtest
bool isPrim(int n)
{
  if(n%2) {
    for(int k=3;n/k>=k;k+=2)
      if(!(n%k)) return false;
    return true;
  }
  return false;
}

///Finds the smallest prime not less then \c n.
int nextPrim(int n)
{
  for(n+=!(n%2);!isPrim(n);n+=2) ;
  return n;
}


/// Class to generate consecutive primes
class Primes 
{
  std::vector<int> primes;
  int n;
  
  bool isPrime(int m) 
  {
    for(int i=0;m<primes[i]*primes[i];i++) if(!(m%primes[i])) return false;
    return true;
  }
public:
  Primes() : n(1) {}
  
  int operator() ()
    {
      if(primes.size()==0) {
	primes.push_back(2);
	return 2;
      }
      else {
	do n+=2; while(!isPrime(n));
	primes.push_back(n);
	return n;
      }
    }
};


#endif
