#! /usr/bin/env python
#
# This file is a part of LEMON, a generic C++ optimization library.
#
# Copyright (C) 2003-2010
# Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
# (Egervary Research Group on Combinatorial Optimization, EGRES).
#
# Permission to use, modify and distribute this software is granted
# provided that this copyright notice appears in all copies. For
# precise terms see the accompanying LICENSE file.
#
# This software is provided "AS IS" with no warranty of any kind,
# express or implied, and with no claim as to its suitability for any
# purpose.
#

import sys
import os
import copy
import re

max_sec_number=100
max_sec_depth=4

def sec_inc(section, lev):
    while len(section)<lev:
        section.append(0)
    section[lev-1]+=1
    section=section[:lev]
    return section

def format_sec(sec):
    s=""
    for i in sec:
        s+=str(i)+'.'
    s=s[:-1]
    return s

def compare_sec(id1, id2):
    id1=id1.split('.')
    c1=0
    for s in id1:
        c1=c1*max_sec_number+int(s)
    for i in range(len(id1), max_sec_depth+1):
        c1*=max_sec_number
    id2=id2.split('.')
    c2=0
    for s in id2:
        c2=c2*max_sec_number+int(s)
    for i in range(len(id2), max_sec_depth+1):
        c2*=max_sec_number
    return c1-c2

section = [];
toc={}
ind={}
page_files={}
ordered_pages = []

for doxfile in os.listdir('.'):
    if doxfile[-4:]=='.dox':
        for l in open(doxfile).readlines():
            gr = re.match(r"(^[[]PAGE[]].*[[]PAGE[]])?(.*)$", l).groups()
            if gr[0]:
                page=gr[0][6:-6]
                page_files[page]=doxfile

prev_page=''
for l in open("toc.txt").readlines():
    sl = l.split()
    if len(sl)==2 and len(sl[0])>0: 
        lev=len(sl[0])
        section=sec_inc(section,lev)
        t_sec=copy.copy(section)
        t_link=sl[1];
        print format_sec(t_sec),t_link
        ind[t_link]=[t_sec,'','']
        if lev==1:
            ind[t_link][1]=prev_page
            if prev_page:
                ind[prev_page][2]=t_link
            prev_page=t_link
            ordered_pages.append(t_link)
        toc[format_sec(t_sec)]=t_link

for doxfile in os.listdir('.'):
    if doxfile[-4:]=='.dox':
        print 'Generate ',doxfile
        page=''
        fo=open(os.path.join("gen-dox",doxfile),"w")
        for l in open(doxfile).readlines():
            gr = re.match(r"(^[[]PAGE[]].*[[]PAGE[]])?(^[[]SEC[]].*[[]SEC[]])?(^[[]TRAILER[]])?(^[[]TOC[]])?(.*)$", l).groups()
            if gr[0]:
                page=gr[0][6:-6]
                fo.write("\page %s %s%s\n"%(page,
                                            format_sec(ind[page][0]),gr[4]))
            elif gr[1]:
                sec=gr[1][5:-5]
                fo.write("\section %s %s%s\n"%(sec,
                                               format_sec(ind[sec][0]),gr[4]))
            elif gr[2]:
                prev_page=ind[page][1]
                if prev_page:
                    prev_str= ( '<< \\ref '+prev_page+' ')
                else:
                    prev_str=''
                next_page=ind[page][2]
                if next_page:
                    next_str= ( ' \\ref '+next_page+' >>')
                else:
                    next_str=''
                fo.write('%s| \\ref sec_toc "Home" |%s\n'%\
                             (prev_str,next_str))
            elif gr[3]:
                secs = [ x for x in toc ]
                secs.sort(compare_sec)
                for num in secs:
                    fo.write("%s - \\ref %s\n"%('  '*((len(ind[toc[num]][0]))),
                                                toc[num]))
            else:
                fo.write(gr[4]+'\n')
        fo.close()

fpdf=open(os.path.join("gen-pdf-dox","full.dox"),"w")
for doxfile in [page_files[p] for p in ordered_pages]:
    page=''
    for l in open(doxfile).readlines():
        gr = re.match(r"(^[[]PAGE[]].*[[]PAGE[]])?(^[[]SEC[]].*[[]SEC[]])?(^[[]TRAILER[]])?(^[[]TOC[]])?(.*)$", l).groups()
        if gr[0]:
            page=gr[0][6:-6]
            fpdf.write("\page %s %s\n"%(page,gr[4]))
        elif gr[1]:
            sec=gr[1][5:-5]
            fpdf.write("\section %s %s\n"%(sec,gr[4]))
        elif gr[2]:
            pass
        elif gr[3]:
            pass
        else:
            fpdf.write(gr[4]+'\n')
fpdf.close()
