#include <iostream>
#include <vector>

#include "test_tools.h"
#include <hugo/maps.h>
#include <hugo/kruskal.h>
#include <hugo/list_graph.h>
#include <hugo/skeletons/maps.h>
#include <hugo/skeletons/graph.h>


using namespace std;
using namespace hugo;

void checkCompileKruskal()
{
  skeleton::WriteMap<skeleton::StaticGraph::Edge,bool> w;

  kruskalEdgeMap(skeleton::StaticGraph(),
		 skeleton::ReadMap<skeleton::StaticGraph::Edge,int>(),
		 w);
}

int main() {

  typedef ListGraph::Node Node;
  typedef ListGraph::Edge Edge;
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EdgeIt EdgeIt;

  ListGraph G;

  Node s=G.addNode();
  Node v1=G.addNode();
  Node v2=G.addNode();
  Node v3=G.addNode();
  Node v4=G.addNode();
  Node t=G.addNode();
  
  Edge e1 = G.addEdge(s, v1);
  Edge e2 = G.addEdge(s, v2);
  Edge e3 = G.addEdge(v1, v2);
  Edge e4 = G.addEdge(v2, v1);
  Edge e5 = G.addEdge(v1, v3);
  Edge e6 = G.addEdge(v3, v2);
  Edge e7 = G.addEdge(v2, v4);
  Edge e8 = G.addEdge(v4, v3);
  Edge e9 = G.addEdge(v3, t);
  Edge e10 = G.addEdge(v4, t);

  typedef ListGraph::EdgeMap<int> ECostMap;
  typedef ListGraph::EdgeMap<bool> EBoolMap;

  ECostMap edge_cost_map(G, 2);
  EBoolMap tree_map(G);
  

  //Test with const map.
  check(kruskalEdgeMap(G, ConstMap<ListGraph::Edge,int>(2), tree_map)==10,
	"Total cost should be 10");
  //Test with a edge map (filled with uniform costs).
  check(kruskalEdgeMap(G, edge_cost_map, tree_map)==10,
	"Total cost should be 10");

  edge_cost_map.set(e1, -10);
  edge_cost_map.set(e2, -9);
  edge_cost_map.set(e3, -8);
  edge_cost_map.set(e4, -7);
  edge_cost_map.set(e5, -6);
  edge_cost_map.set(e6, -5);
  edge_cost_map.set(e7, -4);
  edge_cost_map.set(e8, -3);
  edge_cost_map.set(e9, -2);
  edge_cost_map.set(e10, -1);

  vector<Edge> tree_edge_vec;

  //Test with a edge map and inserter.
  check(kruskalEdgeMap_IteratorOut(G, edge_cost_map,
				   back_inserter(tree_edge_vec))
	==-31,
	"Total cost should be -31.");

  tree_edge_vec.clear();

  //The above test could also be coded like this:
  check(kruskal(G,
		makeKruskalMapInput(G, edge_cost_map),
		makeKruskalSequenceOutput(back_inserter(tree_edge_vec)))
	==-31,
	"Total cost should be -31.");

  check(tree_edge_vec.size()==5,"The tree should have 5 edges.");

  check(tree_edge_vec[0]==e1 &&
	tree_edge_vec[1]==e2 &&
	tree_edge_vec[2]==e5 &&
	tree_edge_vec[3]==e7 &&
	tree_edge_vec[4]==e9,
	"Wrong tree.");

  return 0;
}
