// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <list>

#include <hugo/dimacs.h>
#include <bfs_dfs_misc.h>
#include <list_graph.h>
#include <hugo/graph_wrapper.h>
#include <hugo/maps.h>
#include <for_each_macros.h>

using namespace hugo;

using std::cout;
using std::endl;

int main() {
  typedef ListGraph Graph;
  Graph g;
  readDimacs(std::cin, g); 
 
  {
    std::list<Graph::Node> l;
    //NullMap<Graph::Node, Graph::Edge> pred;
    Graph::NodeMap<Graph::Edge> pred(g, INVALID);
    topSort(g, l, pred);
    cout << "Leaving order of dfs which is pretopological..." << endl;
    for(std::list<Graph::Node>::const_iterator i=l.begin(); i!=l.end(); ++i) {
      cout << *i << " ";
    }
    cout << endl;
    
    FOR_EACH_LOC(Graph::NodeIt, n, g) {
      cout << "pred of node " << n << " is " << pred[n] << endl;
    }
  }
  
  {
    typedef RevGraphWrapper<Graph> GW;
    GW gw(g);
    std::list<GW::Node> l;
    //NullMap<GW::Node, GW::Edge> pred;
    GW::NodeMap<Graph::Edge> pred(gw, INVALID);
    topSort(gw, l, pred);
    cout << "Same in the reversed oriented graph..." << endl;
    for(std::list<GW::Node>::const_iterator i=l.begin(); i!=l.end(); ++i) {
      cout << *i << " ";
    }
    cout << endl;

    FOR_EACH_LOC(GW::NodeIt, n, gw) {
      cout << "pred of node " << n << " is " << pred[n] << endl;
    }
  }

  return 0;
}
