/* -*- C++ -*-
 * src/lemon/lin_expr.h - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef LEMON_LIN_EXPR_H
#define LEMON_LIN_EXPR_H

#include<vector>


#include<map>

///\file
///\brief Classes to handle linear expressions
namespace lemon {
  
  /// Class to handle sparse linear expressions
  template <class _V,class _C>
  class SparseLinExpr : public std::map<_V, _C>
  {
  public:
    typedef _V Var; 
    typedef _C Coeff;
    
  protected:
    typedef typename std::map<_V, _C> Base;

    Coeff const_comp;
  public:
    SparseLinExpr() { }
    SparseLinExpr(const Var &v) : const_comp(v) {
      Base::insert(std::make_pair(v, 1));
    }
    SparseLinExpr(const Coeff &v) : const_comp(v) {}
    
    void set(const Var &v,const Coeff &c) {
      return Base::insert(std::make_pair(v, c));
    }
//     Coeff &operator[](const Var &v) { return data[v]; }
//     const Coeff &operator[](const Var &v) const { return data[v]; }

    Coeff &constComp() { return const_comp; }
    const Coeff &constComp() const { return const_comp; }

    ///Removes the components with zero coefficient.
    void simplify() {
      for (typename Base::iterator i=Base::begin(); i!=Base::end();) {
	typename Base::iterator j=i;
	++j;
	if ((*i).second==0) Base::erase(i);
	j=i;
      }
    }
   
  };

} //namespace lemon

#endif //LEMON_LIN_EXPR_H
