#ifndef VECTOR_EDGE_MAP_H
#define VECTOR_EDGE_MAP_H

#include <vector>

#include "edge_map_base.h"

template <typename G, typename E, typename V> 
class VectorEdgeMap : public EdgeMapBase<G, E>{
public:
	typedef V ValueType;
	
	VectorEdgeMap(Graph& g) : EdgeMapBase<G, E>(g) {}
	
	void add(const E& edge) {
		if (edge->id >= container.size()) {
			container.resize(edge->id);
		}
	}
	
	void erase(const E&) {}

private:
	typedef vector<ValueType> Container;
	
	Container container;
}

#endif