#ifndef NODE_MAP_BASE_H
#define NODE_MAP_BASE_H

template <class G, class K>
class NodeMapBase {
public:
	typedef G Graph;

	typedef K KeyType;
	

	MapBase() : graph(0) {}
	MapBase(Graph& g) : graph(&g) {graph.node_maps.add(*this);}

	virtual ~MapBase() {graph.node_maps.erase(*this);}	

protected:
	
	Graph* graph;

	int graph_index;
	
	
	virtual void add(const KeyType&) = 0;
	virtual void erase(const KeyType&) = 0;

	friend class Graph;
};

#endif
