#include <iostream>
#include "test_tools.h"
#include <hugo/list_graph.h>
#include <hugo/mincostflows.h>
//#include <path.h>
//#include <maps.h>

using namespace std;
using namespace hugo;



bool passed = true;
/*
void check(bool rc, char *msg="") {
  passed = passed && rc;
  if(!rc) {
    std::cerr << "Test failed! ("<< msg << ")" << std::endl; \
 

  }
}
*/


int main()
{

  typedef ListGraph::Node Node;
  typedef ListGraph::Edge Edge;

  ListGraph graph;

  //Ahuja knyv pldja

  Node s=graph.addNode();
  Node v1=graph.addNode();  
  Node v2=graph.addNode();
  Node v3=graph.addNode();
  Node v4=graph.addNode();
  Node v5=graph.addNode();
  Node t=graph.addNode();

  Edge s_v1=graph.addEdge(s, v1);
  Edge v1_v2=graph.addEdge(v1, v2);
  Edge s_v3=graph.addEdge(s, v3);
  Edge v2_v4=graph.addEdge(v2, v4);
  Edge v2_v5=graph.addEdge(v2, v5);
  Edge v3_v5=graph.addEdge(v3, v5);
  Edge v4_t=graph.addEdge(v4, t);
  Edge v5_t=graph.addEdge(v5, t);
  

  ListGraph::EdgeMap<int> length(graph);

  length.set(s_v1, 6);
  length.set(v1_v2, 4);
  length.set(s_v3, 10);
  length.set(v2_v4, 5);
  length.set(v2_v5, 1);
  length.set(v3_v5, 5);
  length.set(v4_t, 8);
  length.set(v5_t, 8);

  ConstMap<Edge, int> const1map(1);
  std::cout << "Mincostflows algorithm test..." << std::endl;

  
  int k=3;
  MinCostFlows< ListGraph, ListGraph::EdgeMap<int>, ConstMap<Edge, int> >
    surb_test(graph, length, const1map);

  check(  surb_test.run(s,t,k) == 2 && surb_test.totalLength() == 46,"Two paths, total length should be 46");

  check(surb_test.checkComplementarySlackness(), "Is the primal-dual solution pair really optimal?");

  k=1;
  check(  surb_test.run(s,t,k) == 1 && surb_test.totalLength() == 19,"One path, total length should be 19");

  check(surb_test.checkComplementarySlackness(), "Is the primal-dual solution pair really optimal?");
  

  cout << (passed ? "All tests passed." : "Some of the tests failed!!!")
       << endl;

  return passed ? 0 : 1;

}
