// -*- C++ -*- //

#ifndef HUGO_DEBUG_H
#define HUGO_DEBUG_H

//! \file
//! \brief Basic definitions for debug control.

namespace hugo {

  struct DebugOn {
    //! Example: check whether the edges added to a path are adjacent
    static const bool consistensy_check = true;

    static const bool range_check = true;

    //! Examples: initialize maps with some value;
    //! after deleting an item from UnionFindEnum set its value in the
    //! corresponding map to NULL...
    static const bool ensure_safe_state = true;
  };

  struct DebugOff {
    static const bool consistensy_check = false;
    static const bool range_check = false;
    static const bool ensure_safe_state = false;
  };

#ifdef DEBUG
  typedef DebugOn DefaultDebugMode;
#else
  typedef DebugOff DefaultDebugMode;
#endif

}
#endif // HUGO_DEBUG_H
