#include <string>
#include <iostream>

#include <path.h>
#include <list_graph.h>

using namespace std;
using namespace hugo;

bool passed = true;

void check(bool rc) {
  passed = passed && rc;
  if(!rc) {
    cout << "Test failed!" << endl;
  }
}

int main() {

  typedef ListGraph::Node Node;
  typedef ListGraph::Edge Edge;

  ListGraph G;

  Node s=G.addNode();
  Node v1=G.addNode();
  Node v2=G.addNode();
  Node v3=G.addNode();
  Node v4=G.addNode();
  Node t=G.addNode();
  
  Edge e1 = G.addEdge(s, v1);
  Edge e2 = G.addEdge(s, v2);
  Edge e3 = G.addEdge(v1, v2);
  Edge e4 = G.addEdge(v2, v1);
  Edge e5 = G.addEdge(v1, v3);
  Edge e6 = G.addEdge(v3, v2);
  Edge e7 = G.addEdge(v2, v4);
  Edge e8 = G.addEdge(v4, v3);
  Edge e9 = G.addEdge(v3, t);
  Edge e10 = G.addEdge(v4, t);

  bool rc;

  cout << "Ures path letrehozasa" << endl;
  typedef Path<ListGraph> LPath;
  LPath P(G);

  cout << "P.length() == " << P.length() << endl;
  check(P.length() == 0);

  cout << "P.from() valid? " << G.valid(P.from()) << endl;
  check(! G.valid(P.from()));

  cout << "Hozzaadunk ket elet..." << endl;
  check(P.pushBack(e1));
  check(P.pushBack(e3));
  cout << "P.length() == " << P.length() << endl;
  check(P.length() == 2);

  cout << "P.from() valid? " << G.valid(P.from()) << endl;
  check(G.valid(P.from()));
  
  cout << "P.from()==s ? " << (P.from()==s) << endl;
  check(P.from() == s);

  cout << "Hozzaadunk egy nem illeszkedo elt." << endl;
  rc = P.pushBack(e8);
  cout << "Sukerult: " << rc << endl;
  check(!rc);

  cout << "Meg 3 el hozzaadasa, nem mind sorrendben..." << endl;
  check(P.pushBack(e6));
  check(P.pushBack(e8));
  check(P.pushBack(e10));

  cout << "P.length() == " << P.length() << endl;
  check(P.length() == 5);

  cout << "P.from()==s ? " << (P.from()==s) << endl;
  check(P.from() == s);
  cout << "P.to()==t ? " << (P.to()==t) << endl;
  check(P.to() == t);

  cout << "Vegpont bellitasa: " << endl;
  rc = P.setTo(v2);
  cout << "Hibasra: " << rc << endl;
  check(!rc);
  rc = P.setTo(t);
  cout << "Helyesre: " << rc << endl;
  check(rc);

  cout << "Elek iranyitasanak ellenorzese." << endl;
  cout << "El: " << e1 << ", G.tail(el): " << G.head(e1) << endl;
  check(G.tail(e1)==s);

  cout << "Vegigiteralunk az eleken." << endl;
  typedef LPath::NodeIt NodeIt;
  typedef LPath::EdgeIt EdgeIt;
  EdgeIt e = P.first<EdgeIt>();
  int i=1;
  for(; P.valid(e); P.next(e), ++i) {
    cout << i << ". el: " << P.graphEdge(e)
	 << ", elore el? " << P.isForward(e) << endl;
    if(i>=3 && i<5) 
      check(!P.isForward(e));
    else
      check(P.isForward(e));
  }

  {
    cout << "Reszut letrehozasa: [2. el, 4. el)..." << endl;
    LPath P2(P, P.nth<EdgeIt>(1), P.nth<EdgeIt>(3));

    cout << "P2.length() == " << P2.length() << endl;
    check(P2.length() == 2);
    
    cout << "P2.from()==v1 ? " << (P2.from()==v1) << endl;
    check(P2.from() == v1);
    cout << "P2.to()==v3 ? " << (P2.to()==v3) << endl;
    check(P2.to() == v3);
  }
  {
    cout << "Reszut letrehozasa: [1. el, 6. el)..." << endl;
    LPath P2(P, P.nth<EdgeIt>(0), P.nth<EdgeIt>(5));

    cout << "P2.length() == " << P2.length() << endl;
    check(P2.length() == 5);
    
    cout << "P2.from()==s ? " << (P2.from()==s) << endl;
    check(P2.from() == s);
    cout << "P2.to()==t ? " << (P2.to()==t) << endl;
    check(P2.to() == t);
  }

  {
    cout << "Ket pont altal megadott reszut letrehozasa: [2. pont, 4. pont]..."
	 << endl;
    LPath P2(P, P.nth<NodeIt>(1), P.nth<NodeIt>(3));

    cout << "P2.length() == " << P2.length() << endl;
    check(P2.length() == 2);
    
    cout << "P2.from()==v1 ? " << (P2.from()==v1) << endl;
    check(P2.from() == v1);
    cout << "P2.to()==v3 ? " << (P2.to()==v3) << endl;
    check(P2.to() == v3);
  }
  {
    cout << "Egy pontu reszut letrehozasa: [4. pont, 4. pont]..."
	 << endl;
    LPath P2(P, P.nth<NodeIt>(3), P.nth<NodeIt>(3));

    cout << "P2.length() == " << P2.length() << endl;
    check(P2.length() == 0);
    
    cout << "P2.from()==v3 ? " << (P2.from()==v3) << endl;
    check(P2.from() == v3);
    cout << "P2.to()==v3 ? " << (P2.to()==v3) << endl;
    check(P2.to() == v3);
  }
  {
    cout << "Forditott ut letrehozasa: [6. pont, 1. pont]..."
	 << endl;
    LPath P2(P, P.nth<NodeIt>(5), P.nth<NodeIt>(0));

    cout << "P2.length() == " << P2.length() << endl;
    check(P2.length() == 5);
    
    cout << "P2.from()==t ? " << (P2.from()==t) << endl;
    check(P2.from() == t);
    cout << "P2.to()==s ? " << (P2.to()==s) << endl;
    check(P2.to() == s);
  }


  cout << (passed ? "All tests passed." : "Some of the tests failed!!!")
       << endl;

  return passed ? 0 : 1;
}
