/* -*- C++ -*-
 * src/lemon/lp_glpk.h - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef LEMON_LP_GLPK_H
#define LEMON_LP_GLPK_H

///\file
///\brief Header of the LEMON-GLPK lp solver interface.

#include "lp_base.h"
extern "C" {
#include "glpk.h"
}

namespace lemon {


  /// \brief Wrapper for GLPK solver
  /// 
  /// This class implements a lemon wrapper for GLPK.
  class LpGlpk : public LpSolverBase {

  public:

    typedef LpSolverBase Parent;
    
    /// \e
    LPX* lp;

    /// \e
    LpGlpk() : Parent(), 
			lp(lpx_create_prob()) {
      lpx_set_int_parm(lp, LPX_K_DUAL, 1);
    }
    /// \e
    ~LpGlpk() {
      lpx_delete_prob(lp);
    }

  protected:
    virtual int _addCol();
    virtual int _addRow();
    virtual void _setRowCoeffs(int i, 
			       int length,
                               int   * indices, 
                               Value   * values );
    virtual void _setColCoeffs(int i, 
			       int length,
                               int   * indices, 
                               Value   * values);
    virtual void _setColLowerBound(int i, Value value);
    virtual void _setColUpperBound(int i, Value value);
    virtual void _setRowLowerBound(int i, Value value);
    virtual void _setRowUpperBound(int i, Value value);
    virtual void _setObjCoeff(int i, Value obj_coef);

  };
} //END OF NAMESPACE LEMON

#endif //LEMON_LP_GLPK_H

