// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>
#include <cstdlib>

#include <LEDA/graph.h>
#include <LEDA/mcb_matching.h>
#include <LEDA/list.h>
#include <LEDA/graph_gen.h>

#include <leda_graph_wrapper.h>
#include <sage_graph.h>
//#include <smart_graph.h>
//#include <dimacs.h>
#include <hugo/time_measure.h>
#include <for_each_macros.h>
#include <hugo/graph_wrapper.h>
#include <bipartite_graph_wrapper.h>
#include <hugo/maps.h>
#include <hugo/max_flow.h>

using std::cin;
using std::cout;
using std::endl;

using namespace hugo;

int main() {
  //for leda graph
  leda::graph lg;
  //lg.make_undirected();
  typedef LedaGraphWrapper<leda::graph> Graph;
  Graph g(lg);

  //for UndirSageGraph
  //typedef UndirSageGraph Graph; 
  //Graph g;

  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;

  std::vector<Graph::Node> s_nodes;
  std::vector<Graph::Node> t_nodes;

  int a;
  cout << "number of nodes in the first color class=";
  cin >> a; 
  int b;
  cout << "number of nodes in the second color class=";
  cin >> b; 
  int m;
  cout << "number of edges=";
  cin >> m; 
  int k;
  cout << "A bipartite graph is a random group graph if the color classes \nA and B are partitiones to A_0, A_1, ..., A_{k-1} and B_0, B_1, ..., B_{k-1} \nas equally as possible \nand the edges from A_i goes to A_{i-1 mod k} and A_{i+1 mod k}.\n";
  cout << "number of groups in LEDA random group graph=";
  cin >> k; 
  cout << endl;
  
  leda_list<leda_node> lS;
  leda_list<leda_node> lT;
  random_bigraph(lg, a, b, m, lS, lT, k);

  Graph::NodeMap<int> ref_map(g, -1);
  IterableBoolMap< Graph::NodeMap<int> > bipartite_map(ref_map);

  //generating leda random group graph
  leda_node ln;
  forall(ln, lS) bipartite_map.insert(ln, false);
  forall(ln, lT) bipartite_map.insert(ln, true);

  //making bipartite graph
  typedef BipartiteGraphWrapper<Graph> BGW;
  BGW bgw(g, bipartite_map);


  //st-wrapper
  typedef stBipartiteGraphWrapper<BGW> stGW;
  stGW stgw(bgw);
  ConstMap<stGW::Edge, int> const1map(1);
  stGW::EdgeMap<int> flow(stgw);

  Timer ts;

  ts.reset();
  FOR_EACH_LOC(stGW::EdgeIt, e, stgw) flow.set(e, 0);
  MaxFlow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
    max_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, flow/*, true*/);
  max_flow_test.run();
  cout << "HUGO max matching algorithm based on preflow." << endl 
	    << "Size of matching: " 
	    << max_flow_test.flowValue() << endl;
  cout << "elapsed time: " << ts << endl << endl;

  ts.reset();  
  leda_list<leda_edge> ml=MAX_CARD_BIPARTITE_MATCHING(lg);
  cout << "LEDA max matching algorithm." << endl 
	    << "Size of matching: " 
	    << ml.size() << endl;
  cout << "elapsed time: " << ts << endl << endl;

//   ts.reset();
//   FOR_EACH_LOC(stGW::EdgeIt, e, stgw) flow.set(e, 0);
//   typedef SageGraph MutableGraph;
//   while (max_flow_test.augmentOnBlockingFlow<MutableGraph>()) { }
//   cout << "HUGO max matching algorithm based on blocking flow augmentation." 
// 	    << endl << "Matching size: " 
// 	    << max_flow_test.flowValue() << endl;
//   cout << "elapsed time: " << ts << endl << endl;

  {
  SageGraph hg;
  SageGraph::Node s=hg.addNode();  
  SageGraph::Node t=hg.addNode();
  BGW::NodeMap<SageGraph::Node> b_s_nodes(bgw);  
  BGW::NodeMap<SageGraph::Node> b_t_nodes(bgw);
  
  FOR_EACH_INC_LOC(BGW::ClassNodeIt, n, bgw, BGW::S_CLASS) {
    b_s_nodes.set(n, hg.addNode());
    hg.addEdge(s, b_s_nodes[n]);
  }
  FOR_EACH_INC_LOC(BGW::ClassNodeIt, n, bgw, BGW::T_CLASS) {
    b_t_nodes.set(n, hg.addNode());
    hg.addEdge(b_t_nodes[n], t);
  }

  FOR_EACH_LOC(BGW::EdgeIt, e, bgw) 
    hg.addEdge(b_s_nodes[bgw.tail(e)], b_t_nodes[bgw.head(e)]);

  ConstMap<SageGraph::Edge, int> cm(1);
  SageGraph::EdgeMap<int> flow(hg); //0
  
  Timer ts;

  ts.reset();
  MaxFlow<SageGraph, int, ConstMap<SageGraph::Edge, int>, 
    SageGraph::EdgeMap<int> > 
    max_flow_test(hg, s, t, cm, flow);
  max_flow_test.run();
  cout << "HUGO max matching algorithm on SageGraph by copying the graph, based on preflow." 
	    << endl 
	    << "Size of matching: " 
	    << max_flow_test.flowValue() << endl;
  cout << "elapsed time: " << ts << endl << endl;
  }

  return 0;
}
