// This example was started by Guillaume Laurent.
// It has become a place to dump code that tests parts of the
// gnomemm canvas code. Little thought has been given to the
// actual on-screen output.

#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>
#include <iostream>

class CanvasExample : public Gnome::Canvas::CanvasAA
{
	typedef Gnome::Canvas::CanvasAA Parent;

public:
	CanvasExample();
	virtual ~CanvasExample();

private:
	bool event_handler(GdkEvent* e, bool b);
	Gnome::Canvas::Points coos;
	Gnome::Art::Point * wp;
	Gnome::Canvas::Ellipse ** nodes;
	Gnome::Canvas::Polygon * sides;
	Gnome::Canvas::Group triangle;
};

bool CanvasExample::event_handler(GdkEvent* e, bool b)
{
	bool isbutton=true;
	switch(e->type)
	{
		case GDK_BUTTON_PRESS: printf("Node is pressed!\n"); break;
		//case GDK_BUTTON_RELEASE: printf("Node is released!\n"); break;
		default: isbutton=false; break;
	}
	if(isbutton)
	{
		//(get_item_at(e->button.x, e->button.y))->move(5,5);
		(get_item_at(e->button.x, e->button.y))->hide();
	}
}

CanvasExample::CanvasExample():triangle(*(root()), 0, 0)
{
	double ax=100;
	double ay=100;
	double bx=-100;
	double by=100;
	double cx=0;
	double cy=-100;
	coos.push_back(Gnome::Art::Point(100, 100));
	coos.push_back(Gnome::Art::Point(-100, 100));
	coos.push_back(Gnome::Art::Point(0, -100));

	sides=new Gnome::Canvas::Polygon(triangle, coos);
	*sides << Gnome::Canvas::Properties::outline_color("green");
	sides->property_width_pixels().set_value(10);

	nodes=new ( Gnome::Canvas::Ellipse * ) [4];

	for(int i=0; i<3;i++)
	{
		nodes[i]= new Gnome::Canvas::Ellipse(triangle, coos[i].get_x()-20, coos[i].get_y()-20, coos[i].get_x()+20, coos[i].get_y()+20);
		*(nodes[i]) << Gnome::Canvas::Properties::fill_color("blue");
		*(nodes[i]) << Gnome::Canvas::Properties::outline_color("black");
		(nodes[i])->signal_event().connect(sigc::bind(sigc::mem_fun(*this, &CanvasExample::event_handler),true));
	}

	wp=new Gnome::Art::Point((ax+bx+cx)/3,(ay+by+cy)/3);

	nodes[3]= new Gnome::Canvas::Ellipse(triangle, wp->get_x()-20, wp->get_y()-20, wp->get_x()+20, wp->get_y()+20);
	*(nodes[3]) << Gnome::Canvas::Properties::fill_color("blue");
	*(nodes[3]) << Gnome::Canvas::Properties::outline_color("black");


}

CanvasExample::~CanvasExample()
{
}

//MainWin:

class MainWin : public Gtk::Window
{
public:
	MainWin(const std::string& title);

protected:
	//Member widgets:
	CanvasExample m_canvas;
};

MainWin::MainWin(const std::string& title)
{
	set_title (title);
	add(m_canvas);
	set_default_size(900,600);

	show_all();
}

//main():

int main(int argc, char *argv[])
{
	Gnome::Canvas::init();
	Gtk::Main app(argc, argv);

	MainWin mainwin("Gnome::Canvas Example");
	app.run(mainwin);

	return 0;
}
