/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef DESWIN_H
#define DESWIN_H

#include <all_include.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

class DesignWin : public Gtk::Window
{
private:
  Gtk::SpinButton * attraction;
  Gtk::SpinButton * propulsation;
  Gtk::SpinButton * iteration;
  Gtk::Table table;
  Gtk::Button * close_button;

  sigc::signal<void, double> signal_attraction_ch;
  sigc::signal<void, double> signal_propulsation_ch;
  sigc::signal<void, int> signal_iteration_ch;
  sigc::signal<void> close_run_pr;

  void emit_attraction();
  void emit_propulsation();
  void emit_iteration();
  void emit_closerun(){close_run_pr.emit();};

public:
  ///Close window if escape key is pressed.
  bool closeIfEscapeIsPressed(GdkEventKey* e);

  ///Constructor

  ///It builds the window.
  DesignWin(const std::string&, double, double, int);

  sigc::signal<void, double> signal_attraction(){return signal_attraction_ch;};
  sigc::signal<void, double> signal_propulsation(){return signal_propulsation_ch;};
  sigc::signal<void, int> signal_iteration(){return signal_iteration_ch;};
  sigc::signal<void> close_run(){return close_run_pr;};

  void set_title(std::string);

  void set_data(double, double, int);
};
#endif //DESWIN_H
