/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <eps_win.h>

#include <mapselector.h>

#include <set>

bool EpsWin::closeIfEscapeIsPressed(GdkEventKey* e)
{
  if(e->keyval==GDK_Escape)
  {
    hide();
  }
  return true;
}

EpsWin::EpsWin(const std::string& title, std::vector<std::string> n_nml, std::vector<std::string> s_nml):Gtk::Dialog(title, true, true)
{
  set_default_size(200, 50);

  set_resizable(false);

  signal_key_press_event().connect(sigc::mem_fun(*this, &EpsWin::closeIfEscapeIsPressed));

  table=new Gtk::Table(EPS_PROPERTY_NUM, 1, false);

  std::vector<std::string> labels;
  labels.resize(EPS_PROPERTY_NUM);

  labels[N_MAPS]="Dump visualized nodemaps";
  labels[E_MAPS]="Dump visualizes arcmaps";
  labels[ARROWS]="Show arrows in directed digraphs";
  labels[PAR]="Indicate parallel arcs";

  options.resize(EPS_PROPERTY_NUM);

  for(int i=0;i<EPS_PROPERTY_NUM;i++)
    {
      options[i]=new Gtk::CheckButton(labels[i]);
      (*table).attach(*(options[i]),0,1,i,i+1,Gtk::FILL,Gtk::SHRINK,10,3);
    }

  mapselector=new MapSelector(n_nml, s_nml, "", "Nodeshapes", false, true, NUM);
  mapselector->signal_newmapwin_needed().connect(sigc::mem_fun(*this, &EpsWin::newMapWinNeeded));

  hbox.pack_start(*(new Gtk::Label("Filename")));
  hbox.pack_start(name);

  Gtk::VBox * vbox=get_vbox();

  vbox->pack_start(*table);
  vbox->pack_start(*mapselector);
  vbox->pack_start(hbox);

  //OK button
  add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
  add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);

  show_all_children();

}

bool EpsWin::on_delete_event(GdkEventAny * event)
{
  event=event;
  signal_eps_close.emit();
  return true;
}

void EpsWin::on_response(int response_id)
{
  if(response_id==Gtk::RESPONSE_OK)
    {
      std::vector <bool> values;
      values.resize(EPS_PROPERTY_NUM);
      for(int i=0;i<EPS_PROPERTY_NUM;i++)
	{
	  values[i]=options[i]->get_active();
	}
      signal_eps_details.emit(values, name.get_text(), mapselector->get_active_text());
    }
  on_delete_event(NULL);
}

void EpsWin::newMapWinNeeded(bool isitarc)
{
  signal_new_map.emit(false);
}

void EpsWin::registerNewNodeMap(std::string newmapname, MapValue::Type type)
{
    mapselector->append_text((Glib::ustring)newmapname, type);
}
