/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef EPS_WIN_H
#define EPS_WIN_H

class MapSelector;

#include <all_include.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>
#include "map_value.h"

///Digraph visualization setup window.

///This class is responsible for creating a window,
///on which the visualization attributes can be
///assigned to maps.
class EpsWin : public Gtk::Dialog
{
protected:
  ///Designing element
  Gtk::Table * table;
  
  ///Information holder
  Gtk::Label * label;

  ///configuration
  std::vector<Gtk::CheckButton *> options;

  ///OK, Cancel
  Gtk::Button * ok, * cancel;

  ///Container in which filename entry are organized.
  Gtk::HBox hbox;

  ///Filename
  Gtk::Entry name;

  MapSelector * mapselector;
public:
  ///Constructor

  ///It creates the widgets shown in \ref EpsWin and
  ///binds the needed signal to the correct place.
  ///\param title title of window
  ///\param eml arcmap list
  ///\param nml nodemap list
  ///\param mw the owner \ref NoteBookTab (\ref mytab)
  EpsWin(const std::string& title, std::vector<std::string>, std::vector<std::string>);

  ///Deregistrates \ref EpsWin in its \ref NoteBookTab (\ref mytab)
  virtual bool on_delete_event(GdkEventAny *);

  ///Close window if Esc key pressed.
  virtual bool closeIfEscapeIsPressed(GdkEventKey*);

  ///Callback function for OK button. It creates the map.
  
  ///If OK is pressed this function
  ///transmits the collected data to
  ///appropriate functions to be able
  ///to create EPS
  virtual void on_response(int response_id);

  ///indicates that user is ready to export EPS file
  sigc::signal<void, std::vector<bool>, std::string, std::string > signal_eps_details;

  ///returns \ref signal_eps_details
  sigc::signal<void, std::vector<bool>, std::string, std::string > signal_eps_details_ch(){return signal_eps_details;};

  ///indicates that the windows can be closed
  sigc::signal<void> signal_eps_close;

  ///returns \ref signal_eps_close
  sigc::signal<void> signal_eps_close_ch(){return signal_eps_close;};
  
  ///indicates that the windows can be closed
  sigc::signal<void, bool> signal_new_map;

  ///returns \ref signal_eps_close
  sigc::signal<void, bool> signal_new_map_ch(){return signal_new_map;};

  ///Function is called when new map is required.
  void newMapWinNeeded(bool);

  ///This function inserts name of the new nodemap in the name list in \ref MapSelector s

  ///\param new_name
  ///name of new map
  void registerNewNodeMap(std::string new_name, MapValue::Type type);
};

#endif //EPS_WIN_H
