/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <graph_displayer_canvas.h>
#include <mapstorage.h>
#include <nbtab.h>
#include <cmath>

const int minimum_arc_width=0;

int DigraphDisplayerCanvas::resetArcWidth (Arc arc)
{
  MapStorage& ms = *mytab.mapstorage;
  double min, max;

  min=arc_property_defaults[E_WIDTH];
  max=arc_property_defaults[E_WIDTH];
  Digraph::ArcMap<double> actual_map(ms.digraph,arc_property_defaults[E_WIDTH]);

  if(arc==INVALID)
  {
    for (ArcIt i(ms.digraph); i!=INVALID; ++i)
    {
      double v=fabs(actual_map[i]);
      int w;
      if(min==max)
      {
        w=(int)(arc_property_defaults[E_WIDTH]);
      }
      else
      {
        w=(int)(MIN_EDGE_WIDTH+(v-min)/(max-min)*(MAX_EDGE_WIDTH-MIN_EDGE_WIDTH));
      }
      if(zoomtrack)
      {
        double actual_ppu=get_pixels_per_unit();
        w=(int)(w/actual_ppu*fixed_zoom_factor);
      }
      arcsmap[i]->setLineWidth(w);
    }
  }
  else
  {
    int w=(int)actual_map[arc];
    if(w>=0)
    {
      arcsmap[arc]->setLineWidth(w);
    }
  }
  return 0;
}


int DigraphDisplayerCanvas::changeArcWidth (std::string mapname, Arc arc)
{
  MapStorage& ms = *mytab.mapstorage;
  double min, max;

  {
    ArcIt e(ms.digraph);
    min = max = ms.get(mapname, e);
    for (; e != INVALID; ++e)
    {
      if (static_cast<double>(ms.get(mapname, e)) > max)
        max = ms.get(mapname, e);
      if (static_cast<double>(ms.get(mapname, e)) < min)
        min = ms.get(mapname, e);
    }
  }

  if(arc==INVALID)
  {
    for (ArcIt i(ms.digraph); i!=INVALID; ++i)
    {
      double v=ms.get(mapname, i);
      int w;
      if(autoscale)
      {
        if(min==max)
        {
          w=(int)(arc_property_defaults[E_WIDTH]);
        }
        else
        {
          w=(int)(minimum_arc_width+(v-min)/(max-min)*(arc_width-minimum_arc_width));
        }
      }
      else
      {
        w=(int)(v*arc_width);
      }
      if(w<0)
      {
        arcsmap[i]->hide();
      }
      else
      {
        arcsmap[i]->show();
        if(w<minimum_arc_width)
        {
          w=minimum_arc_width;
        }
        if(zoomtrack)
        {
          double actual_ppu=get_pixels_per_unit();
          w=(int)(w/actual_ppu*fixed_zoom_factor);
        }
        arcsmap[i]->setLineWidth(w);
      }
    }
  }
  else
  {
    int w=(int)ms.get(mapname, arc);
    if(w>=0)
    {
      arcsmap[arc]->setLineWidth(w);
    }
  }
  return 0;
};

int DigraphDisplayerCanvas::changeArcColor (std::string mapname, Arc arc)
{  
  MapStorage& ms = *mytab.mapstorage;

  //function maps the range of the maximum and
  //the minimum of the nodemap to the range of
  //green in RGB

  double max, min;

  {
    ArcIt e(ms.digraph);
    min = max = ms.get(mapname, e);
    for (; e != INVALID; ++e)
    {
      if (static_cast<double>(ms.get(mapname, e)) > max)
        max = ms.get(mapname, e);
      if (static_cast<double>(ms.get(mapname, e)) < min)
        min = ms.get(mapname, e);
    }
  }

  if(arc==INVALID)
    {
      for (ArcIt i(ms.digraph); i!=INVALID; ++i)
	{
	  double w=ms.get(mapname, i);

	  Gdk::Color color;
	  if(max!=min)
	    {
	      color=rainbowColorCounter(min, max, w);
	    }
	  else
	    {
	      color.set_rgb_p (0, 1, 0);
	    }
	  arcsmap[i]->setFillColor(color);
	}
    }
  else
    {
      Gdk::Color color;

      double w=ms.get(mapname, arc);

      if(max!=min)
	{
	  color=rainbowColorCounter(min, max, w);
	}
      else
	{
	  color.set_rgb_p (0, 1, 0);
	}

      arcsmap[arc]->setFillColor(color);
    }
  return 0;
};

int DigraphDisplayerCanvas::resetArcColor (Arc arc)
{  
  MapStorage& ms = *mytab.mapstorage;

  //function maps the range of the maximum and
  //the minimum of the nodemap to the range of
  //green in RGB
  Digraph::ArcMap<double> actual_map(ms.digraph,arc_property_defaults[E_COLOR]);

  double max, min;

  max=arc_property_defaults[E_COLOR];
  min=arc_property_defaults[E_COLOR];

  if(arc==INVALID)
  {
    for (ArcIt i(ms.digraph); i!=INVALID; ++i)
    {
      double w=actual_map[i];

      Gdk::Color color;
      if(max!=min)
      {
        color.set_rgb_p (0, 100*(w-min)/(max-min), 0);
      }
      else
      {
        color.set_rgb_p (0, 100, 0);
      }
      arcsmap[i]->setFillColor(color);
    }
  }
  else
  {
    Gdk::Color color;

    double w=actual_map[arc];

    if(max!=min)
    {
      color.set_rgb_p (0, 100*(w-min)/(max-min), 0);
    }
    else
    {
      color.set_rgb_p (0, 100, 0);
    }

    arcsmap[arc]->setFillColor(color);
  }
  return 0;
};

int DigraphDisplayerCanvas::changeArcText (std::string mapname, Arc arc)
{
  MapStorage& ms = *mytab.mapstorage;

  //the number in the map will be written on the arc
  //EXCEPT when the name of the map is Default, because
  //in that case empty string will be written, because
  //that is the deleter map

  if(arc==INVALID)
  {
    for (ArcIt i(ms.digraph); i!=INVALID; ++i)
    {
      arcmap_to_edit=mapname;

      arctextmap[i]->property_text().set_value(
          static_cast<std::string>(ms.get(mapname, i)));
    }

  }
  else
  {
    arctextmap[arc]->property_text().set_value(
        static_cast<std::string>(ms.get(mapname, arc)));
  }

  return 0;
};

int DigraphDisplayerCanvas::resetArcText (Arc arc)
{
  MapStorage& ms = *mytab.mapstorage;

  //the number in the map will be written on the arc
  //EXCEPT when the name of the map is Default, because
  //in that case empty string will be written, because
  //that is the deleter map

  if(arc==INVALID)
  {
    for (ArcIt i(ms.digraph); i!=INVALID; ++i)
    {
      arcmap_to_edit="";
      arctextmap[i]->property_text().set_value("");
    }
  }
  else
  {
    arctextmap[arc]->property_text().set_value("");
  }

  return 0;
};
