/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <graph_displayer_canvas.h>
#include <cmath>

void DigraphDisplayerCanvas::zoomIn()
{
  set_pixels_per_unit(
      (1.0 + (double) zoom_step / 100.0) * get_pixels_per_unit());
  if(zoomtrack)
    {
      propertyChange(false, N_RADIUS);
      propertyChange(true, E_WIDTH);
    }
}

void DigraphDisplayerCanvas::zoomOut()
{
  set_pixels_per_unit(
      (1.0 - (double) zoom_step / 100.0) * get_pixels_per_unit());
  if(zoomtrack)
    {
      propertyChange(true, E_WIDTH);
      propertyChange(false, N_RADIUS);
    }
}

void DigraphDisplayerCanvas::zoomFit()
{
  updateScrollRegion();

  // get the height and width of the canvas
  Gtk::Allocation a = get_allocation();
  int aw = a.get_width();
  int ah = a.get_height();

  // get the bounding box of the digraph
  update_now();
  double x1, y1, x2, y2;
  root()->get_bounds(x1, y1, x2, y2);

  // fit the digraph to the window
  double ppu1 = (double) aw / fabs(x2 - x1);
  double ppu2 = (double) ah / fabs(y2 - y1);
  set_pixels_per_unit((ppu1 < ppu2) ? ppu1 : ppu2);

  if(zoomtrack)
    {
      propertyChange(true, E_WIDTH);
      propertyChange(false, N_RADIUS);
    }
}

void DigraphDisplayerCanvas::zoom100()
{
  updateScrollRegion();
  set_pixels_per_unit(1.0);

  if(zoomtrack)
    {
      propertyChange(true, E_WIDTH);
      propertyChange(false, N_RADIUS);
    }
}

void DigraphDisplayerCanvas::updateScrollRegion()
{
  // get_bounds() yields something sane only when no updates are pending
  // and it returns a sufficient, not an exact bounding box
  update_now();
  double x1, y1, x2, y2;
  root()->get_bounds(x1, y1, x2, y2);
  set_scroll_region(x1, y1, x2, y2);
}
