/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <lemon/kruskal.h>

#include <mapstorage.h>
#include <mapselector.h>
#include <algobox.h>
#include <kruskalbox.h>

enum {INPUT, OUTPUT, MAP_NUM};

KruskalBox::KruskalBox(std::vector<std::string> t):AlgoBox()
{
  init(t);
}
    
void KruskalBox::run()
{
  if(
      tabcbt.get_active_text()!="" &&
      (arcmapcbts[INPUT])->get_active_text()!="" &&
      (arcmapcbts[OUTPUT])->get_active_text()!=""
    )
  {

    const Digraph &g=mapstorage->getDigraph();
    std::string input_map_name = arcmapcbts[INPUT]->get_active_text();
    Digraph::ArcMap<bool> outputmap(g);
    const MapStorage::NumericArcMap& inputmap=
      mapstorage->getNumericArcMap(input_map_name);
    double res=kruskal(g, inputmap, outputmap);

    for (ArcIt i(g); i!=INVALID; ++i)
    {
      if(outputmap[i])
      {
        mapstorage->set(arcmapcbts[OUTPUT]->get_active_text(), i, 1.0);
      }
      else
      {
        mapstorage->set(arcmapcbts[OUTPUT]->get_active_text(), i, 0.0);
      }
    }

    std::ostringstream o;
    o << "Result: " << res;
    resultlabel.set_text(o.str());

    mapstorage->mapChanged(true, (arcmapcbts[OUTPUT])->get_active_text());
    //   mapstorage->changeActiveMap(true, E_COLOR,
    // 			      (arcmapcbts[OUTPUT])->get_active_text());
    //   mapstorage->changeActiveMap(true, E_TEXT,
    // 			      (arcmapcbts[INPUT])->get_active_text());

  }
}
    
void KruskalBox::build_box()
{
  std::vector<std::string> empty_vector;

  addMapSelector("Arccosts: ", true, NUM);
  addMapSelector("Arcs of tree here: ", true, NUM);

  resultlabel.set_text("Result: algorithm is not run yet.");
  pack_start(resultlabel);
}
