/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef KRUSKALBOX_H
#define KRUSKALBOX_H

class AlgoBox;

#include <all_include.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

///Digraphical interface to run Kruskal algorithm.

///Child of \ref AlgoBox,
///therefore the only task to do at implementation was to
///
///-call init function with correct parameters from correctly parametrized constructor
///
///-implement \ref build_box function
///
///-implement \ref run function
class KruskalBox : public AlgoBox
{
  ///Shows result of Kruskal algorithm
  Gtk::Label resultlabel;

public:
  ///Calls \ref AlgoBox::init function to initialize class properly, automatically.
  KruskalBox(std::vector<std::string> t);

  ///Prepare, run and postprocess Kruskal algorithm.

  ///\ref glemon works only with maps filled with double values
  ///at the moment. While Kruskal nedds a bool map as output.
  ///As postprocess this bool map should be transformed to
  ///double map.
  void run();

  ///Builds the digraphical design of the interface.
  void build_box();
};
#endif //KRUSKALBOX_H
