#ifndef MAP_VALUE_H
#define MAP_VALUE_H

#include <exception>
#include <functional>
#include <iosfwd>

class MapValue
{
  public:
    friend std::ostream& operator<<(std::ostream &os, const MapValue& v);
    class IllegalOperation : public std::exception
    {
      virtual const char* what() const throw()
      {
        return "Illegal operation.";
      }
    };
    typedef enum
    {
      NUMERIC = 1 << 0,
      STRING  = 1 << 1
    } Type;
  private:
    bool has_value;
    void* p_value;
    MapValue::Type type;
    void clear();
  public:
    MapValue();
    MapValue(double);
    MapValue(std::string);
    MapValue(const char* str);
    MapValue(const MapValue& v);
    MapValue& operator=(const MapValue& v);
    ~MapValue();
    operator std::string() const;
    operator double() const;
    Type getType() const;
    bool hasValue() const;
};

#endif
