/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <map_win.h>
#include <nbtab.h>
#include <mapselector.h>
#include <set>

bool MapWin::closeIfEscapeIsPressed(GdkEventKey* e)
{
  if(e->keyval==GDK_Escape)
  {
    mytab.closeMapWin();
    //    hide();
  }
  return true;
}

MapWin::MapWin(const std::string& title,
    std::vector<std::string> n_eml,
    std::vector<std::string> s_eml,
    std::vector<std::string> n_nml,
    std::vector<std::string> s_nml,
    NoteBookTab & mw):mytab(mw)
{
  set_title(title);
  set_default_size(200, 50);

  set_resizable(false);

  signal_key_press_event().connect(sigc::mem_fun(*this, &MapWin::closeIfEscapeIsPressed));

  mytab.signal_title_ch().connect(sigc::mem_fun(*this, &MapWin::set_title));

  e_combo_array=new MapSelector * [EDGE_PROPERTY_NUM];

  table=new Gtk::Table(EDGE_PROPERTY_NUM, 1, false);

  for(int i=0;i<EDGE_PROPERTY_NUM;i++)
  {
    switch (i)
    {
      case E_WIDTH:
        e_combo_array[i]=new MapSelector(n_eml, s_eml,
            mytab.getActiveArcMap(i), arc_property_strings[i],
            true, true, NUM);
        break;
      case E_COLOR:
        e_combo_array[i]=new MapSelector(n_eml, s_eml,
            mytab.getActiveArcMap(i), arc_property_strings[i],
            true, true, NUM);
        break;
      case E_TEXT:
        e_combo_array[i]=new MapSelector(n_eml, s_eml,
            mytab.getActiveArcMap(i), arc_property_strings[i],
            true, true, ALL);
        break;
    }

    (*table).attach((*(e_combo_array[i])),0,1,i,i+1,Gtk::SHRINK,Gtk::SHRINK,10,3);

    e_combo_array[i]->signal_cbt_ch().connect(sigc::bind(sigc::mem_fun(*this, &MapWin::arcMapChanged), i));
    e_combo_array[i]->signal_newmapwin_needed().connect(sigc::mem_fun(*this, &MapWin::newMapWinNeeded));
  }

  vbox.pack_start(*(new Gtk::Label("Arc properties")));

  vbox.pack_start(*table);

  vbox.pack_start(*(new Gtk::HSeparator));

  n_combo_array=new MapSelector * [NODE_PROPERTY_NUM];

  table=new Gtk::Table(NODE_PROPERTY_NUM, 1, false);

  for(int i=0;i<NODE_PROPERTY_NUM;i++)
  {
    switch (i)
    {
      case N_RADIUS:
        n_combo_array[i]=new MapSelector(n_nml, s_nml,
            mytab.getActiveNodeMap(i), node_property_strings[i],
            false, true, NUM);
        break;
      case N_COLOR:
        n_combo_array[i]=new MapSelector(n_nml, s_nml,
            mytab.getActiveNodeMap(i), node_property_strings[i],
            false, true, NUM);
        break;
      case N_TEXT:
        n_combo_array[i]=new MapSelector(n_nml, s_nml,
            mytab.getActiveNodeMap(i), node_property_strings[i],
            false, true, ALL);
        break;
    }

    (*table).attach((*(n_combo_array[i])),0,1,i,i+1,Gtk::SHRINK,Gtk::SHRINK,10,3);

    n_combo_array[i]->signal_cbt_ch().connect(sigc::bind(sigc::mem_fun(*this, &MapWin::nodeMapChanged), i));
    n_combo_array[i]->signal_newmapwin_needed().connect(sigc::mem_fun(*this, &MapWin::newMapWinNeeded));
  }

  add(vbox);

  vbox.pack_start(*(new Gtk::Label("Node properties")));

  vbox.pack_start(*table);

  update(n_eml, s_eml, n_nml, s_nml);

  show_all_children();

}

void MapWin::nodeMapChanged(std::string mapname, int prop)
{
  mytab.propertyChange(false, prop, mapname);
}

void MapWin::arcMapChanged(std::string mapname, int prop)
{
  mytab.propertyChange(true, prop, mapname);
}

void MapWin::newMapWinNeeded(bool itisarc)
{
  mytab.popupNewMapWin(itisarc);
}

void MapWin::update(
    std::vector<std::string> n_eml,
    std::vector<std::string> s_eml,
    std::vector<std::string> n_nml,
    std::vector<std::string> s_nml)
{
  for(int i=0;i<EDGE_PROPERTY_NUM;i++)
  {
    e_combo_array[i]->update_list(n_eml, s_eml);
  }

  for(int i=0;i<NODE_PROPERTY_NUM;i++)
  {
    n_combo_array[i]->update_list(n_nml, s_nml);
  }

  mytab.active_maps_needed();
}

void MapWin::registerNewArcMap(std::string newmapname, MapValue::Type type)
{
  for(int i=0;i<EDGE_PROPERTY_NUM;i++)
  {
    //filling in combo box with choices
    e_combo_array[i]->append_text((Glib::ustring)newmapname, type);
  }
}

void MapWin::registerNewNodeMap(std::string newmapname, MapValue::Type type)
{
  for(int i=0;i<NODE_PROPERTY_NUM;i++)
  {
    //filling in combo box with choices
    n_combo_array[i]->append_text((Glib::ustring)newmapname, type);
  }
}

bool MapWin::on_delete_event(GdkEventAny * event)
{
  event=event;
  mytab.closeMapWin();
  return true;
}

void MapWin::changeEntry(bool isitarc, int prop, std::string mapname)
{
  if(isitarc)
    {
      e_combo_array[prop]->set_active_text(mapname);
    }
  else
    {
      n_combo_array[prop]->set_active_text(mapname);
    }
}

void MapWin::set_title(std::string tabname)
{
  Gtk::Window::set_title("Map Setup - "+tabname);
}
