/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <mapselector.h>

MapSelector::MapSelector(std::vector<std::string> n_ml,
    std::vector<std::string> s_ml, std::string act,
    std::string labeltext, bool arc, bool d, MapType type) :
  def(d),
  itisarc(arc),
  set_new_map(false),
  label(labeltext),
  map_type(type),
  newbut(Gtk::Stock::NEW)
{
  update_list(n_ml, s_ml);

  if(act=="")
  {
    cbt.set_active(0);
    default_state=true;
  }
  else
  {
    cbt.set_active_text((Glib::ustring)act);
    default_state=false;
  }

  //binding signal to the actual entry
  cbt.signal_changed().connect
    (
     sigc::mem_fun((*this), &MapSelector::comboChanged),
     false
    );

  label.set_width_chars(longest_property_string_length);

  if(def)
  {
    defbut.set_label("Reset");
    defbut.signal_pressed().connect
      (
       sigc::mem_fun(*this, &MapSelector::reset)
      );
  }


  newbut.signal_pressed().connect
    (
     sigc::mem_fun(*this, &MapSelector::new_but_pressed)
    );

  add(label);

  add(cbt);

  if(def)
  {
    add(defbut);
  }

  add(newbut);
}

void MapSelector::new_but_pressed()
{
  set_new_map=true;
  signal_newmapwin.emit(itisarc);
}

void MapSelector::update_list(std::vector<std::string> n_ml,
    std::vector<std::string> s_ml)
{
  int prev_act=cbt.get_active_row_number();
  cbt.clear();
  cbt_content.clear();

  if (map_type & NUM)
  {
    std::vector< std::string >::iterator emsi=n_ml.begin();
    for(;emsi!=n_ml.end();emsi++)
    {
      cbt.append_text(*emsi);
      cbt_content.push_back(*emsi);
    }
  }
  if (map_type & STR)
  {
    std::vector< std::string >::iterator emsi=s_ml.begin();
    for(;emsi!=s_ml.end();emsi++)
    {
      cbt.append_text(*emsi);
      cbt_content.push_back(*emsi);
    }
  }
  if(def)
    {
      cbt.prepend_text("Default values");
      cbt_content.push_back("Default values");
    }
  if(prev_act!=-1)
    {
      cbt.set_active(prev_act);
    }
}

void MapSelector::comboChanged()
{
  if(cbt.get_active_row_number()!=0 || !def)
    {
      default_state=false;
      Glib::ustring mapname = cbt.get_active_text();
      if(!(mapname.empty())) //We seem to get 2 signals, one when the text is empty.
	{
	  signal_cbt.emit(mapname);
	}
    }
  else if((!default_state)&&(cbt.get_active_row_number()==0))
    {
      reset();
    }
}

void MapSelector::reset()
{
  default_state=true;

  cbt.set_active(0);

  signal_cbt.emit("");
}


Glib::ustring MapSelector::get_active_text()
{
  return cbt.get_active_text();
}

void MapSelector::set_active_text(Glib::ustring text)
{
  if(text.compare(""))
    {
      cbt.set_active_text(text);
    }
  else
    { 
      cbt.set_active_text("Default values");
    }
}

void MapSelector::append_text(Glib::ustring text, MapValue::Type type)
{
  if (type & map_type)
  {
    cbt.append_text(text);
    cbt_content.push_back(text);

    if(set_new_map)
    {
      set_active_text(text);
      set_new_map=false;
    }
  }
}

sigc::signal<void, std::string> MapSelector::signal_cbt_ch()
{
  return signal_cbt;
}

sigc::signal<void, bool> MapSelector::signal_newmapwin_needed()
{
  return signal_newmapwin;
}
