#ifndef SAVE_DETAILS_WIDGET
#define SAVE_DETAILS_WIDGET

#include <gtkmm/entry.h>
#include <gtkmm/box.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/label.h>
#include <gtkmm/notebook.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include <gtkmm/scrolledwindow.h>

class MapStorage;

class SaveDetailsWidget : public Gtk::VBox
{
  public:
    struct MapModelColumns : public Gtk::TreeModel::ColumnRecord
    {
      MapModelColumns()
      {
        add(colName);
        add(colSaveToMainSect);
        add(colSaveToGuiSect);
      }
      Gtk::TreeModelColumn<Glib::ustring> colName;
      Gtk::TreeModelColumn<bool> colSaveToMainSect;
      Gtk::TreeModelColumn<bool> colSaveToGuiSect;
    };
  private:
    Gtk::RadioButton rbLgfFile;
    Gtk::RadioButton rbConfFile;

    Gtk::TreeView twNodeMaps;
    Gtk::TreeView twArcMaps;

    MapModelColumns NodeMapColumns;
    MapModelColumns ArcMapColumns;

    Glib::RefPtr<Gtk::ListStore> refNodeMapStore;
    Glib::RefPtr<Gtk::ListStore> refArcMapStore;

    Gtk::RadioButton rblueCoordGuiSection;
    Gtk::RadioButton rblueCoordNodesetSection;
    Gtk::RadioButton rblueCoordOneMap;
    Gtk::RadioButton rblueCoordTwoMaps;
    Gtk::Entry entNodeCoordsOneMap;
    Gtk::Entry entNodeCoordsTwoMaps1;
    Gtk::Entry entNodeCoordsTwoMaps2;

    Gtk::RadioButton rbArrowCoordGuiSection;
    Gtk::RadioButton rbArrowCoordArcsetSection;
    Gtk::RadioButton rbArrowCoordOneMap;
    Gtk::RadioButton rbArrowCoordTwoMaps;
    Gtk::Entry entArrowCoordsOneMap;
    Gtk::Entry entArrowCoordsTwoMaps1;
    Gtk::Entry entArrowCoordsTwoMaps2;

    MapStorage* pMapStorage;

    void onGuiSectSaveDestChanged();

    void onNodeCoordSaveDestChanged();
    void onNodeCoordMapNumChanged();

    void onNodeCoordsOneMapName();
    void onNodeCoordsTwoMaps1Name();
    void onNodeCoordsTwoMaps2Name();

    void onArrowCoordSaveDestChanged();
    void onArrowCoordMapNumChanged();

    void onArrowCoordsOneMapName();
    void onArrowCoordsTwoMaps1Name();
    void onArrowCoordsTwoMaps2Name();

    void onArcMapRowChanged(const Gtk::TreeModel::Path& path,
        const Gtk::TreeModel::iterator& iter);
    void onNodeMapRowChanged(const Gtk::TreeModel::Path& path,
        const Gtk::TreeModel::iterator& iter);
  public:
    SaveDetailsWidget(MapStorage* ms);
    ~SaveDetailsWidget();
};

#endif
