#ifndef MAP_DEFINES_H
#define MAP_DEFINES_H

#define CREATE_EDGE_MAP_REGISTRY \
typedef MapRegistry<Graph, Edge, EdgeIt> EdgeMapRegistry; \
EdgeMapRegistry edge_maps;

#define CREATE_NODE_MAP_REGISTRY \
typedef MapRegistry<Graph, Node, NodeIt> NodeMapRegistry; \
NodeMapRegistry node_maps;

#define CREATE_MAP_REGISTRIES \
CREATE_NODE_MAP_REGISTRY \
CREATE_EDGE_MAP_REGISTRY

#define CREATE_NODE_MAP_FACTORY(TemplateFactory) \
typedef TemplateFactory<NodeMapRegistry> NodeMapFactory;

#define CREATE_EDGE_MAP_FACTORY(TemplateFactory) \
typedef TemplateFactory<EdgeMapRegistry> EdgeMapFactory;

#define CREATE_MAP_FACTORIES(TemplateFactory) \
CREATE_NODE_MAP_FACTORY(TemplateFactory) \
CREATE_EDGE_MAP_FACTORY(TemplateFactory) 

#define IMPORT_NODE_MAP(Factory) \
template <typename V> \
class NodeMap : public Factory::Map<V> { \
public: \
NodeMap() {} \
NodeMap(Graph& g) : Factory::Map<V>(g, g.node_maps) {} \
};

#define IMPORT_EDGE_MAP(Factory) \
template <typename V> \
class EdgeMap : public Factory::Map<V> { \
public: \
EdgeMap() {} \
EdgeMap(Graph& g) : Factory::Map<V>(g, g.edge_maps) {} \
};

#define CREATE_MAPS(TemplateFactory) \
CREATE_MAP_FACTORIES(TemplateFactory) \
IMPORT_NODE_MAP(NodeMapFactory) \
IMPORT_EDGE_MAP(EdgeMapFactory)

#endif
