#include<list_graph.h>
#include<skeletons/graph.h>

#include <iostream>
#include <vector>

using namespace hugo;

typedef ListGraph Graph;
//typedef GraphSkeleton Graph;


Graph::OutEdgeIt safeFirstOut(const Graph &G, Graph::Node n)
{
  return G.valid(n) ? Graph::OutEdgeIt(G,n):INVALID;
}

int main()
{

  typedef Graph::Edge Edge;
  typedef Graph::InEdgeIt InEdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  
  Graph G;
  
  {
    NodeIt n;

    for(int i=0;i<10;i++) G.addNode();
    for(G.first(n);G.valid(n);G.next(n)) 
      for(NodeIt m(G);m!=INVALID;G.next(m)) 
	if(n!=m) G.addEdge(n,m);
    
    OutEdgeIt e = safeFirstOut(G,n);
    OutEdgeIt f = safeFirstOut(G,NodeIt(G));
    
    
    InEdgeIt i(INVALID), j;
    InEdgeIt ii(i);
    ii=G.first(i,n);
    ii=G.next(i);
    
    OutEdgeIt o(INVALID), oo;
    OutEdgeIt ooo(oo);
    oo=G.first(o,n);
    oo=G.next(o);
    
    EdgeIt ei(INVALID), eie;
    EdgeIt eiee(ei);
    eie=G.first(ei);
    eie=G.next(ei);
    
    Edge eee(i);
    eee=o;
    eee=eie;
    
    
    bool tm;
    tm = G.valid(n) && G.valid(i) && G.valid(o) && G.valid(ei);
    
    std::vector<InEdgeIt> v(10);
    std::vector<InEdgeIt> w(10,INVALID);
    
  }
  
  // Test of maps

  G.clear();
  
  for(int i=0;i<10;i++) G.addNode();
  for(NodeIt i(G);G.valid(i);G.next(i)) 
    for(NodeIt j(G);G.valid(j);G.next(j)) 
      if(i<j) G.addEdge(i,j);           //The iterators are comparable
  
  Graph::NodeMap<int> n(G);
  int count=0;
  for(NodeIt i(G);G.valid(i);G.next(i)) n[i]=count++;
  
  Graph::NodeMap<int> nn=n;
  Graph::NodeMap<double> dd=n;

  n = nn;
  
  dd = nn;
  
  Graph::EdgeMap<int> emap(G);

  // Test of SymListGraph
  
  {
    typedef SymListGraph Graph;
    typedef Graph::Edge Edge;
    typedef Graph::InEdgeIt InEdgeIt;
    typedef Graph::OutEdgeIt OutEdgeIt;
    typedef Graph::EdgeIt EdgeIt;
    typedef Graph::Node Node;
    typedef Graph::NodeIt NodeIt;

    Graph G;

    for(int i=0;i<10;i++) G.addNode();
    for(NodeIt i(G);G.valid(i);G.next(i)) 
      for(NodeIt j(G);G.valid(j);G.next(j)) 
	if(i<j) G.addEdge(i,j);           //The iterators are comparable
  
    Graph::EdgeMap<int> em(G);
    Graph::SymEdgeMap<int> sm(G);
    for(EdgeIt e(G);G.valid(e);G.next(e)) em[e]=G.id(e);
    for(EdgeIt e(G);G.valid(e);G.next(e))
      if(G.tail(e)<G.head(e)) sm[e]=G.id(e);
    
    for(EdgeIt e(G);G.valid(e);G.next(e))
      std::cout << G.id(G.tail(e)) << "->" << G.id(G.head(e))
		<< ": id=" << G.id(e) << " oppid=" << G.id(G.opposite(e))
		<< " em=" << em[e]
		<< " sm=" << sm[e] << "\n";
    
    //Delete all nodes
    NodeIt n;
    while(G.valid(G.first(n))) G.erase(n);
  }

  // Tests for NodeSet and EdgeSet
  
  {
    NodeSet N;
    
    typedef EdgeSet<NodeSet> ES;
    
    ES E(N);
    ES F(N);
    for(int i=0;i<10;i++) G.addNode();
    
    for(ES::NodeIt n(E);E.valid(n);E.next(n))
      for(ES::NodeIt m(E);E.valid(m);E.next(m))
	if(n!=m) F.addEdge(n,m);
    for(ES::NodeIt n(F);F.valid(n);F.next(n))
      for(ES::NodeIt m(F);F.valid(m);F.next(m))
	if(n<m) F.addEdge(n,m);
    

    NodeSet::NodeMap<int> nm1(N);
    ES::NodeMap<int> nm2(E);
    ES::EdgeMap<int> eme(E);
    ES::EdgeMap<int> emf(F);
    
       
  }
  
}
