#include <fstream>
#include <iostream>

#include <lemon/xy.h>
#include <lemon/maps.h>
#include <lemon/error.h>
#include <lemon/list_graph.h>
#include <lemon/graph_reader.h>
#include <lemon/graph_utils.h>

using namespace lemon;

typedef ListGraph Graph;
typedef xy<double> Coordinates;
typedef Graph::NodeMap<Coordinates> CoordinatesMap;
typedef Graph::Node Node;
typedef Graph::EdgeIt EdgeIt;
typedef Graph::NodeIt NodeIt;

class CoordReaderMap: public MapBase <Node, double>
{
    CoordinatesMap & cm;
    char xoy;

public:
    CoordReaderMap(char xory, CoordinatesMap & coordmap): cm(coordmap)
    {
	switch(xory)
	{
	    case 'x':
	    case 'y':
		xoy=xory;
		break;
	    default:
		throw UninitializedParameter() ;
	}
    }

    void set(Node node, double coord)
    {
	switch(xoy)
	{
	    case 'x':
		cm[node].x=coord;
		break;
	    case 'y':
		cm[node].y=coord;
		break;
	    default:
		throw UninitializedParameter() ;
	}
    }
};

int main(void)
{
    Graph g;
    CoordinatesMap cm(g);

    CoordReaderMap xreader('x',cm);
    CoordReaderMap yreader('y',cm);

    std::ifstream is("graphocska.lemon");
    
    GraphReader<Graph> reader(is, g);
    reader.addNodeMap("coordinates_x", xreader);
    reader.addNodeMap("coordinates_y", yreader);
    reader.run();
    std::cout << "Megvagyok" << std::endl;

    for (NodeIt i(g); i!=INVALID; ++i)
	std::cout << " " << g.id(i) << " " << cm[i];
    std::cout << std::endl;

    return 0;
}
