#ifndef VECTOR_MAP_H
#define VECTOR_MAP_H

#include <vector>

namespace hugo {
	
  template <typename MapRegistry>
    class VectorMapFactory {
    public:
		
    typedef typename MapRegistry::Graph Graph;
    typedef typename MapRegistry::Key Key;
    typedef typename MapRegistry::KeyIt KeyIt;

    typedef typename MapRegistry::MapBase MapBase;

		
    template <typename V> 
      class Map : public MapBase {
      public:
      typedef V Value;
	
      typedef std::vector<Value> Container;
      Map() {}
			
      Map(Graph& g, MapRegistry& r) : MapBase(g, r) {
	init();
      }
			
						
      virtual ~Map() {
	destroy();
      }
	
	
      typename Container::reference operator[](const Key& key) {
	int id = graph->id(key);
	return container[id];
      } 
		
      typename Container::const_reference operator[](const Key& key) const {
	int id = graph->id(key);
	return container[id];
      }
	
      void set(const Key& key, const Value& val) {
	int id = graph->id(key);
	container[id] = val;
      }
		
      void add(const Key& key) {
	int id = graph->id(key);
	if (id >= container.size()) {
	  container.resize(id + 1);
	}
      }
		
      void erase(const Key& key) {}
	
      class const_iterator {

      private:
      
      };

      class iterator {
      public:
	iterator() {}
      
	std::pair<const Key&, Value&> operator*() {
	  return std::pair<const Key&, Value&>(static_cast<Key&>(it), map[it]);
	}

	iterator& operator++() { ++it; return *this; }
	iterator operator++(int) { iterator tmp(it); ++it; return tmp; }
      private:
	Map& map;
	KeyIt it;
      };

      private:
      typedef std::vector<Value> Container;
		
      Container container;


    };

    

		
  };
}

#endif
