// -*- c++ -*- 
#ifndef HUGO_MAP_BITS_H
#define HUGO_MAP_BITS_H

///\ingroup graphmaps
///\file
///\brief Some utils to help implement maps.

namespace hugo {


  /// \addtogroup graphmaps
  /// @{

  /// Helper class to get information about the key type.
  template <typename Graph, typename KeyIt>
  struct KeyInfo {};

  template <typename Graph>
  struct KeyInfo<Graph, typename Graph::NodeIt> {
    static int maxId(const Graph& graph) {
      return graph.maxNodeId();
    }
    static int id(const Graph& graph, const typename Graph::Node& node) {
      return graph.id(node);
    }
  };

  template <typename Graph>
  struct KeyInfo<Graph, typename Graph::EdgeIt> {
    static int maxId(const Graph& graph) {
      return graph.maxEdgeId();
    }
    static int id(const Graph& graph, const typename Graph::Edge& edge) {
      return graph.id(edge);
    }
  };

  template <typename Graph>
  struct KeyInfo<Graph, typename Graph::SymEdgeIt> {
    static int maxId(const Graph& graph) {
      return graph.maxEdgeId() >> 1;
    }
    static int id(const Graph& graph, const typename Graph::Edge& edge) {
      return graph.id(edge) >> 1;
    }
  };

  /// @}
}

#endif
