#include <iostream>
//#include "test_tools.h"
#include <hugo/list_graph.h>
#include <mincostflow.h>
//#include <path.h>
//#include <maps.h>

using namespace std;
using namespace hugo;



bool passed = true;

void check(bool rc, char *msg="") {
  passed = passed && rc;
  if(!rc) {
    std::cerr << "Test failed! ("<< msg << ")" << std::endl; \
 

  }
}



int main()
{

  typedef ListGraph::Node Node;
  typedef ListGraph::Edge Edge;

  ListGraph graph;

  //Ahuja knyv pldja

  Node s=graph.addNode();
  Node v1=graph.addNode();  
  Node v2=graph.addNode();
  Node v3=graph.addNode();
  Node v4=graph.addNode();
  Node v5=graph.addNode();
  Node t=graph.addNode();

  ListGraph::NodeMap<int> supply_demand(graph);

  supply_demand.set(s, 2);
  supply_demand.set(v1, 3);
  supply_demand.set(v3, -1);
  supply_demand.set(t, -4);

  Edge s_v1=graph.addEdge(s, v1);
  Edge v1_v2=graph.addEdge(v1, v2);
  Edge s_v3=graph.addEdge(s, v3);
  Edge v2_v4=graph.addEdge(v2, v4);
  Edge v2_v5=graph.addEdge(v2, v5);
  Edge v3_v5=graph.addEdge(v3, v5);
  Edge v4_t=graph.addEdge(v4, t);
  Edge v5_t=graph.addEdge(v5, t);
  

  ListGraph::EdgeMap<int> cost(graph);

  cost.set(s_v1, 6);
  cost.set(v1_v2, 4);
  cost.set(s_v3, 10);
  cost.set(v2_v4, 5);
  cost.set(v2_v5, 1);
  cost.set(v3_v5, 4);
  cost.set(v4_t, 8);
  cost.set(v5_t, 8);

  /*
  ListGraph::EdgeMap<int> capacity(graph);

  capacity.set(s_v1, 2);
  capacity.set(v1_v2, 2);
  capacity.set(s_v3, 1);
  capacity.set(v2_v4, 1);
  capacity.set(v2_v5, 1);
  capacity.set(v3_v5, 1);
  capacity.set(v4_t, 1);
  capacity.set(v5_t, 2);
  */

  //  ConstMap<Edge, int> const1map(1);
  std::cout << "Enhanced capacity scaling algorithm test (for the mincostflow problem)..." << std::endl;

  MinCostFlow< ListGraph, ListGraph::EdgeMap<int>, ListGraph::NodeMap<int> >
    min_cost_flow_test(graph, cost, supply_demand);

  min_cost_flow_test.run();
  //int k=1;
  check(min_cost_flow_test.checkOptimality(), "Is the primal-dual solution pair really optimal?");

  /*
  check(  min_cost_flow_test.run(s,t,k) == 1 && min_cost_flow_test.totalLength() == 19,"One path, total cost should be 19");

  check(min_cost_flow_test.checkComplementarySlackness(), "Is the primal-dual solution pair really optimal?");
  
  k=2;
  
  check(  min_cost_flow_test.run(s,t,k) == 2 && min_cost_flow_test.totalLength() == 41,"Two paths, total cost should be 41");

  check(min_cost_flow_test.checkComplementarySlackness(), "Is the primal-dual solution pair really optimal?");
  
  
  k=4;

  check(  min_cost_flow_test.run(s,t,k) == 3 && min_cost_flow_test.totalLength() == 64,"Three paths, total cost should be 64");

  check(min_cost_flow_test.checkComplementarySlackness(), "Is the primal-dual solution pair really optimal?");

  */
  cout << (passed ? "All tests passed." : "Some of the tests failed!!!")
       << endl;

  return passed ? 0 : 1;
  
}
