/* -*- C++ -*-
 * src/lemon/lp_cplex.cc
 * - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include"lp_cplex.h"

///\file
///\brief Implementation of the LEMON-CPLEX lp solver interface.
namespace lemon {
  
  int LpCplex::_addCol()
  {
    int i = CPXgetnumcols (env, lp);
    Value lb[1],ub[1];
    lb[0]=-INF;//-CPX_INFBOUND;
    ub[0]=INF;//CPX_INFBOUND;
    status = CPXnewcols (env, lp, 1, NULL, lb, ub, NULL, NULL);
    return i;
  }
  
  int LpCplex::_addRow() 
  {
    //We want a ranged row
    char sense[1];
    sense[0]='R';

    int i = CPXgetnumrows (env, lp);
    status = CPXnewrows (env, lp, 1, NULL, sense, NULL, NULL);
    return i;
  }
  
  ///\warning Data at index 0 is ignored iin the arrays.
  void LpCplex::_setRowCoeffs(int i, 
			      int length,
			      int  const * indices, 
			      Value  const * values )
  {
    int rowlist[length+1];
    int* p=rowlist;
    for (int k=1;k<=length;++k){
      rowlist[k]=i;
    }
    status = CPXchgcoeflist(env, lp, 
			    length, 
			    p++, 
			    const_cast<int * >(indices++), 
			    const_cast<Value * >(values++));
  }
  
  void LpCplex::_setColCoeffs(int i, 
			      int length,
			      int  const * indices, 
			      Value  const * values)
  {
    int collist[length+1];
    int* p=collist;
    for (int k=1;k<=length;++k){
      collist[k]=i;
    }
    status = CPXchgcoeflist(env, lp, 
			    length, 
			    const_cast<int * >(indices++), 
			    p++, 
			    const_cast<Value * >(values++));
  }
  
  void LpCplex::_setColLowerBound(int i, Value value)
  {
    int indices[1];
    indices[0]=i;
    char lu[1];
    lu[0]='L';
    Value bd[1];
    bd[0]=value;
    status = CPXchgbds (env, lp, 1, indices, lu, bd);
 
  }
  
  void LpCplex::_setColUpperBound(int i, Value value)
  {
    int indices[1];
    indices[0]=i;
    char lu[1];
    lu[0]='U';
    Value bd[1];
    bd[0]=value;
    status = CPXchgbds (env, lp, 1, indices, lu, bd);
  }
  
  void LpCplex::_setRowLowerBound(int i, Value value)
  {
    status = CPXchgcoef (env, lp, i, -1, value);

  }
  
  void LpCplex::_setRowUpperBound(int i, Value value)
  {
    //TODO Ezt kell meg megirni
    //    Value lo=CPX
  }
  
  void LpCplex::_setObjCoeff(int i, Value obj_coef)
  {
    status = CPXchgcoef (env, lp, -1, i, obj_coef);
   }

  LpCplex::SolveExitStatus LpCplex::_solve()
  {
    return SOLVED;
//     int i=  lpx_simplex(lp);
//     switch (i) {
//     case LPX_E_OK: 
//       return SOLVED;
//       break;
//     default:
//       return UNSOLVED;
//     }
  }

  LpCplex::Value LpCplex::_getPrimal(int i)
  {
    return 0;
  }
  
  LpCplex::Value LpCplex::_getPrimalValue()
  {
    return 0;
  }
  
 
  LpCplex::SolutionStatus LpCplex::_getPrimalStatus()
  {
    return OPTIMAL;
//     int stat=  lpx_get_status(lp);
//     switch (stat) {
//     case LPX_UNDEF://Undefined (no solve has been run yet)
//       return UNDEFINED;
//       break;
//     case LPX_NOFEAS://There is no feasible solution (primal, I guess)
//     case LPX_INFEAS://Infeasible 
//       return INFEASIBLE;
//       break;
//     case LPX_UNBND://Unbounded
//       return INFINITE;
//       break;
//     case LPX_FEAS://Feasible
//       return FEASIBLE;
//       break;
//     case LPX_OPT://Feasible
//       return OPTIMAL;
//       break;
//     default:
//       return UNDEFINED; //to avoid gcc warning
//       //FIXME error
//     }
  }


  void LpCplex::_setMax()
  {
    CPXchgobjsen (env, lp, CPX_MAX);
   }
  void LpCplex::_setMin()
  {
    CPXchgobjsen (env, lp, CPX_MIN);
   }
  
} //namespace lemon

