/* -*- C++ -*-
 * src/test/graph_wrapper_test.cc - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include<iostream>
#include<lemon/smart_graph.h>
#include<lemon/skeletons/graph.h>
#include<lemon/list_graph.h>
#include<lemon/full_graph.h>
#include<lemon/graph_wrapper.h>

#include"test/test_tools.h"
#include"test/graph_test.h"

/**
\file
This test makes consistency checks of graph wrappers.

\todo More extensive tests are needed 
*/

using namespace lemon;


typedef SmartGraph Graph;

//Compile GraphWrapper
typedef GraphWrapper<Graph> GW;
template void lemon::skeleton::checkCompileStaticGraph<GW>(GW &);

//Compile RevGraphWrapper
typedef RevGraphWrapper<Graph> RevGW;
template void lemon::skeleton::checkCompileStaticGraph<RevGW>(RevGW &);

//Compile SubGraphWrapper
typedef SubGraphWrapper<Graph, Graph::NodeMap<bool>, 
			Graph::EdgeMap<bool> > SubGW;
template void lemon::skeleton::checkCompileStaticGraph<SubGW>(SubGW &);

//Compile NodeSubGraphWrapper
typedef NodeSubGraphWrapper<Graph, Graph::NodeMap<bool> > NodeSubGW;
template void lemon::skeleton::checkCompileStaticGraph<NodeSubGW>(NodeSubGW &);

//Compile EdgeSubGraphWrapper
typedef EdgeSubGraphWrapper<Graph, Graph::EdgeMap<bool> > EdgeSubGW;
template void lemon::skeleton::checkCompileStaticGraph<EdgeSubGW>(EdgeSubGW &);

//Compile UndirGraphWrapper
/// \bug UndirGraphWrapper cannot pass the StaticGraph test
//typedef UndirGraphWrapper<Graph> UndirGW;
//template void checkCompileStaticGraph<UndirGW>(UndirGW &);

//Compile UndirGraph
//typedef UndirGraph<Graph> UndirG;
//template void checkCompileStaticGraph<UndirG>(UndirG &);

//Compile SubBidirGraphWrapper
typedef SubBidirGraphWrapper<Graph, Graph::EdgeMap<bool>, 
			     Graph::EdgeMap<bool> > SubBDGW;
template void lemon::skeleton::checkCompileStaticGraph<SubBDGW>(SubBDGW &);

//Compile BidirGraphWrapper
typedef BidirGraphWrapper<Graph> BidirGW;
template void lemon::skeleton::checkCompileStaticGraph<BidirGW>(BidirGW &);

//Compile BidirGraph
typedef BidirGraph<Graph> BidirG;
template void lemon::skeleton::checkCompileStaticGraph<BidirG>(BidirG &);

//Compile ResGraphWrapper
typedef ResGraphWrapper<Graph, int, Graph::EdgeMap<int>, 
			Graph::EdgeMap<int> > ResGW;
template void lemon::skeleton::checkCompileStaticGraph<ResGW>(ResGW &);

//Compile ErasingFirstGraphWrapper
typedef ErasingFirstGraphWrapper<Graph, Graph::NodeMap<Graph::Edge> > ErasingFirstGW;
template
void lemon::skeleton::checkCompileStaticGraph<ErasingFirstGW>(ErasingFirstGW &);


int main() 
{
  std::cout << __FILE__ ": All tests passed.\n";

  return 0;
}
